package ru.yandex.msearch.proxy.api.async.mail.subscriptions;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;

import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;

import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;

import ru.yandex.msearch.proxy.AsyncHttpServer;

import ru.yandex.search.rules.BasicSearchRequest;
import ru.yandex.search.rules.RequestParams;
import ru.yandex.search.rules.ResolveUserRule;
import ru.yandex.search.rules.SearchInfo;
import ru.yandex.search.rules.SearchRequest;
import ru.yandex.search.rules.SearchRule;

public class SubscriptionsHandler
    implements HttpAsyncRequestHandler<HttpRequest>
{
    private final AsyncHttpServer server;
    private final SearchRule<SubscriptionsStat, RequestParams, SearchInfo> rule;
    private final SearchRule<SubscriptionsStat, RequestParams, SearchInfo> reindexRule;

    public SubscriptionsHandler(
        final AsyncHttpServer server)
        throws IOException
    {
        this.server = server;

        this.rule =
            new ResolveUserRule<>(
                new SelectSubscriptionRule(
                    new FastSubscriptionsRule(server),
                    new FullScanSubscriptionsRule(server)),
                server::blackboxClient);
        this.reindexRule =
            new ResolveUserRule<>(
                new SubscriptionsReindexer(
                    server,
                    new FullScanSubscriptionsRule(server)),
                server::blackboxClient);
    }

    @Override
    public BasicAsyncRequestConsumer processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        ProxySession session = new BasicProxySession(server, exchange, context);
        boolean reindex = session.params().getBoolean("reindex", false);
        SubscriptionsService service = new SubscriptionsService();

        SearchRequest<SubscriptionsStat, RequestParams, SearchInfo> sr =
            new BasicSearchRequest<>(session, service);

        if (reindex) {
            reindexRule.execute(sr);
        } else {
            rule.execute(sr);
        }
    }
}