package ru.yandex.msearch.proxy.api.async.mail.subscriptions;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.client.AbstractAsyncClient;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.mail.search.subscriptions.SubscriptionsConstants;
import ru.yandex.msearch.proxy.AsyncHttpServer;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.EnumParser;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.search.prefix.LongPrefix;
import ru.yandex.search.proxy.universal.UniversalSearchProxyRequestContext;

public class SubscriptionsListContext
    extends SubscriptionsBaseContext
    implements UniversalSearchProxyRequestContext
{
    public static final int OPTIN_FRESH_TIME= 31;
    private static final CollectionParser<SubscriptionStatus, Set<SubscriptionStatus>, RuntimeException> STATUS_SET_PARSER =
        new CollectionParser<>(
            new EnumParser<>(SubscriptionStatus.class),
            LinkedHashSet::new);

    private final Set<SubscriptionStatus> statuses;
    private final int length;
    private final int offset;

    public SubscriptionsListContext(
        final AsyncHttpServer proxy,
        final ProxySession session)
        throws BadRequestException
    {
        super(proxy, session);

        CgiParams params = session.params();

        statuses = params.get("statuses", STATUS_SET_PARSER);
        offset = params.getInt("offset", 0);
        length = params.getInt("length", 0);
    }

    public Set<SubscriptionStatus> statuses() {
        return statuses;
    }

    public int length() {
        return length;
    }

    public int offset() {
        return offset;
    }
}
