package ru.yandex.msearch.proxy.api.async.mail.subscriptions;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.function.GenericFunction;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.mail.search.subscriptions.SubscriptionsConstants;
import ru.yandex.msearch.proxy.AsyncHttpServer;
import ru.yandex.msearch.proxy.api.async.BasicSession;
import ru.yandex.msearch.proxy.api.async.Session;
import ru.yandex.msearch.proxy.api.async.mail.BasicSearchSession;
import ru.yandex.msearch.proxy.api.async.mail.MailSearchHandler;
import ru.yandex.msearch.proxy.api.async.mail.RequestInfo;
import ru.yandex.msearch.proxy.api.async.mail.SearchAttributes;
import ru.yandex.msearch.proxy.api.async.mail.result.ResultPrinter;
import ru.yandex.msearch.proxy.api.async.mail.rules.PlainSearchRule;
import ru.yandex.msearch.proxy.api.async.mail.rules.RuleContext;
import ru.yandex.msearch.proxy.api.async.mail.rules.SearchRule;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.parser.uri.QueryConstructor;

public class SubscriptionsMailsHandler
    implements HttpAsyncRequestHandler<HttpRequest>
{
    private final AsyncHttpServer server;
    private final SearchRule rule;

    public SubscriptionsMailsHandler(final AsyncHttpServer server) {
        this.server = server;
        this.rule =
            new PlainSearchRule(
                new RuleContext(
                    server,
                    MailSearchHandler.BasicDocumentsFactory.INSTANCE,
                    SubscriptionsAttributesFactory.INSTANCE));
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(
        final HttpRequest httpRequest,
        final HttpContext httpContext)
        throws HttpException, IOException
    {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        Session httpSession = new BasicSession(server, exchange, context);
        SubscriptionsBaseContext subsContext = new SubscriptionsBaseContext(server, httpSession);
        CgiParams params = httpSession.params();
        RequestInfo requestInfo =
            new RequestInfo(httpSession, request, params);

        Set<String> types = SubscriptionsConstants.OPT_IN_TYPES;
//        Set<String> types = SubscriptionsConstants.TYPES;
//        if (subsContext.optIn()) {
//            types = SubscriptionsConstants.OPT_IN_TYPES;
//        }

        StringBuilder sb = new StringBuilder();
        sb.append("hdr_from_normalized:");
        sb.append(params.getString("email"));
        sb.append(" AND message_type:(");
        int i = 0;
        for (String type: types) {
            if (i != 0) {
                sb.append(" OR ");
            }

            sb.append(type);
            i++;
        }
        sb.append(')');

        httpSession.params().replace("request", sb.toString());
        httpSession.params().putIfAbsent("mdb", Collections.singletonList("pg"));

        rule.execute(
            new BasicSearchSession(
                requestInfo,
                httpSession.params(),
                new ResultPrinter(requestInfo)));
    }

    private enum SubscriptionsAttributesFactory
        implements GenericFunction<
        CgiParams,
        SearchAttributes,
        BadRequestException>
    {
        INSTANCE;

        @Override
        public SearchAttributes apply(final CgiParams params)
            throws BadRequestException
        {
            return new SubscriptionsSearchAttributes();
        }
    }

    private static class SubscriptionsSearchAttributes
        implements SearchAttributes
    {

        public SubscriptionsSearchAttributes() {
        }

        @Override
        public String luceneGet() {
            return "mid,hid";
        }

        @Override
        public String luceneGroup() {
            return null;
        }

        @Override
        public String luceneMergeFunc() {
            return "none";
        }

        @Override
        public String rewriteLuceneQuery(final String query) {
            return query;
        }

        @Override
        public void appendToLuceneRequest(
            final QueryConstructor query)
            throws BadRequestException
        {

        }

        @Override
        public boolean onlyUnread() {
            return false;
        }

        @Override
        public boolean excludeTrash() {
            return false;
        }

        @Override
        public boolean excludeSpam() {
            return false;
        }

        @Override
        public boolean excludePending() {
            return false;
        }

        @Override
        public boolean excludeHiddenSubscriptions() {
            return false;
        }

        @Override
        public void appendToFilterSearchRequest(
            final QueryConstructor query) throws BadRequestException {

        }

        @Override
        public int requestedResultsMultipier() {
            return 0;
        }
    }
}
