package ru.yandex.msearch.proxy.api.async.mail.subscriptions;

import java.io.IOException;
import java.io.OutputStreamWriter;

import java.nio.charset.CodingErrorAction;

import java.util.Map;

import org.apache.http.HttpStatus;

import org.apache.http.entity.ContentType;

import org.apache.http.nio.entity.NByteArrayEntity;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;

import ru.yandex.http.util.BadRequestException;

import ru.yandex.http.util.nio.NByteArrayEntityFactory;

import ru.yandex.io.DecodableByteArrayOutputStream;

import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;

public class SubscriptionsPrinter
    extends AbstractProxySessionCallback<SubscriptionsStat>
{
    // evristic
    private final double READ_FALLBACK_THRESHOLD = 80;
    private final double SHOW_FALLBACK_THRESHOLD = 8;

    private final JsonType jsonType;
    private final boolean full;

    public SubscriptionsPrinter(final ProxySession session)
        throws BadRequestException
    {
        super(session);

        this.jsonType = JsonTypeExtractor.NORMAL.extract(session.params());
        this.full = session.params().getBoolean("full", false);
    }

    private void writeShort(
        final JsonWriter writer,
        final Map.Entry<String, SubscriptionEntry> entry)
        throws IOException
    {
        writer.key("email");
        writer.value(entry.getValue().from().trim());
        writer.key("displayName");
        writer.value(entry.getValue().displayName().trim());
        writer.key("mid");
        writer.value(entry.getValue().mid());
        writer.key("searchEmail");
        writer.value(entry.getValue().searchEmail().trim());
        writer.key("readFrequency");
        writer.value(entry.getValue().percentShow() / 100.0);
        writer.key("type");
        writer.value(entry.getKey());
    }

    private void writeFull(
        final JsonWriter writer,
        final Map.Entry<String, SubscriptionEntry> entry)
        throws IOException
    {
        writer.key("from");
        writer.value(entry.getValue().from());
        writer.key("displayName");
        writer.value(entry.getValue().displayName());
        writer.key("searchEmail");
        writer.value(entry.getValue().searchEmail());
        writer.key("percentWithFlagSeen");
        writer.value(entry.getValue().percentFlagSeen());
        writer.key("mid");
        writer.value(entry.getValue().mid());
        writer.key("percentShow");
        writer.value(entry.getValue().percentShow());
        writer.key("seenFlag");
        writer.value(entry.getValue().seenFlag());
        writer.key("show");
        writer.value(entry.getValue().shows());
        writer.key("total");
        writer.value(entry.getValue().total());
        writer.key("type");
        writer.value(entry.getKey());
    }

    @Override
    public void completed(final SubscriptionsStat stat) {
        DecodableByteArrayOutputStream out =
            new DecodableByteArrayOutputStream();
        try (OutputStreamWriter outWriter =
                 new OutputStreamWriter(
                     out,
                     session.acceptedCharset().newEncoder()
                         .onMalformedInput(CodingErrorAction.REPLACE)
                         .onUnmappableCharacter(CodingErrorAction.REPLACE));
             JsonWriter writer = jsonType.create(outWriter))
        {
            writer.startArray();

            for (SubscriptionsSender sender: stat.sort()) {
                for (Map.Entry<String, SubscriptionEntry> entry:
                    sender.types().entrySet())
                {
                    writer.startObject();
                    if (full) {
                        writeFull(writer, entry);
                    } else {
                        writeShort(writer, entry);
                    }
                    writer.endObject();
                }
            }

            writer.endArray();
        } catch (IOException e) {
            failed(e);
            return;
        }

        NByteArrayEntity entity =
            out.processWith(NByteArrayEntityFactory.INSTANCE);
        entity.setContentType(
            ContentType.APPLICATION_JSON.withCharset(
                session.acceptedCharset())
                .toString());
        session.response(HttpStatus.SC_OK, entity);

    }
}
