package ru.yandex.msearch.proxy.api.async.mail.subscriptions;

import java.util.logging.Logger;

import ru.yandex.http.proxy.ProxySession;

import ru.yandex.http.util.BadRequestException;

import ru.yandex.http.util.nio.client.AbstractAsyncClient;

import ru.yandex.msearch.proxy.AsyncHttpServer;

import ru.yandex.parser.searchmap.User;

import ru.yandex.search.proxy.SearchProxyParams;

import ru.yandex.search.proxy.universal.UniversalSearchProxyRequestContext;

public class SubscriptionsProxyContext
    implements UniversalSearchProxyRequestContext
{
    private final AsyncHttpServer server;
    private final User user;
    private final ProxySession session;

    public SubscriptionsProxyContext(
        final ProxySession session,
        final AsyncHttpServer server,
        final User user)
    {
        this.server = server;
        this.user = user;
        this.session = session;
    }

    public long failoverDaelay() throws BadRequestException {
        long failoverSearchDelay =
            server.config().subscriptionsConfig().failoverDelay();
        failoverSearchDelay = session.params().getLongDuration(
            SearchProxyParams.FAILOVER_DELAY,
            failoverSearchDelay);

        return failoverSearchDelay;
    }

    @Override
    public User user() {
        return user;
    }

    @Override
    public Long minPos() {
        return null;
    }

    @Override
    public AbstractAsyncClient<?> client() {
        return server.searchClient();
    }

    @Override
    public Logger logger() {
        return session.logger();
    }

    @Override
    public long lagTolerance() {
        return Long.MAX_VALUE;
    }
}
