package ru.yandex.msearch.proxy.api.async.mail.subscriptions;

import java.util.LinkedHashMap;
import java.util.Map;

public class SubscriptionsSender
    implements Comparable<SubscriptionsSender>
{
    private final Map<String, SubscriptionEntry> types;
    private long date;
    private int total;

    public SubscriptionsSender(
        final Map<String, SubscriptionEntry> source,
        final long minimumTotal)
    {
        int total = 0;

        long maxDate = 0L;
        this.types = new LinkedHashMap<>(source.size());
        for (Map.Entry<String, SubscriptionEntry> entry :
            source.entrySet())
        {
            total += entry.getValue().total();
            if (entry.getValue().total() >= minimumTotal) {
                this.types.put(entry.getKey(), entry.getValue());
            }

            maxDate = Math.max(entry.getValue().date(), maxDate);
        }

        this.date = maxDate;
        this.total = total;
    }

    public Map<String, SubscriptionEntry> types() {
        return types;
    }

    public int total() {
        return total;
    }

    @Override
    public int compareTo(final SubscriptionsSender o) {
        return - Long.compare(this.date, o.date);
    }
}
