package ru.yandex.msearch.proxy.api.async.mail.subscriptions.update;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.concurrent.CompletedFuture;
import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.FilterFutureCallback;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.msearch.proxy.AsyncHttpServerBase;
import ru.yandex.msearch.proxy.config.ImmutableAsyncHttpServerBaseConfig;

public class FuritaBatchingMover extends FilterFutureCallback<Object> {
    private final SubscriptionsFuritaRulesApplier ruleApplier;
    private final SubscriptionsFuritaAppliableRules ruleMatcher;
    private final Collection<String> emails;
    private final AtomicInteger offset = new AtomicInteger(0);
    private final SubscriptionsUpdateContext context;
    private final AsyncHttpServerBase
        <? extends ImmutableAsyncHttpServerBaseConfig> proxy;
    private final List<UpdateItem> itemsList;

    public FuritaBatchingMover(
        final AsyncHttpServerBase<? extends ImmutableAsyncHttpServerBaseConfig>
            proxy,
        final SubscriptionsUpdateContext context,
        final List<UpdateItem> itemList,
        final FutureCallback<Object> callback)
    {
        super(callback);
        this.context = context;
        this.itemsList = itemList;
        this.proxy = proxy;
        ruleApplier =
            new SubscriptionsFuritaRulesApplier(
                context.httpContext(),
                proxy.mopsClient(),
                proxy.config().mopsClientConfig().host());

        emails = itemList.stream().map(UpdateItem::email).collect(Collectors.toSet());
        ruleMatcher =
            new SubscriptionsFuritaAppliableRules(proxy, context);
    }

    public void next(final int offset) {
        try {
            ruleMatcher.next(new MatchCallback(callback), emails, offset);
        } catch (BadRequestException bre) {
            failed(bre);
        }
    }

    private class MatchCallback
        extends AbstractFilterFutureCallback<List<Map.Entry<String, List<FuritaRule>>>, Object>
    {
        public MatchCallback(final FutureCallback<? super Object> callback) {
            super(callback);
        }

        @Override
        public void completed(final List<Map.Entry<String, List<FuritaRule>>> midsWithMatchedRules) {
            boolean next = midsWithMatchedRules.size() >= context.moveExistingBatchSize();
            StringBuilder matched = new StringBuilder();
            for (Map.Entry<String, List<FuritaRule>> entry: midsWithMatchedRules) {
                if (entry.getValue().size() > 0) {
                    matched.append(entry.getKey());
                    matched.append(':');
                    List<FuritaRule> rules = entry.getValue();
                    Collections.sort(rules);
                    for (FuritaRule rule: entry.getValue()) {
                        matched.append(rule.id());
                        matched.append(' ');
                    }
                }

            }
            context.logger().info(
                "Mids fetched " + midsWithMatchedRules.size() + " nextBatch " + next + " matched: " + matched);
            ruleApplier.apply(context, midsWithMatchedRules, new MoveCallback(callback, next));
        }
    }

    private class MoveCallback extends FilterFutureCallback<Object> {
        private final boolean next;
        public MoveCallback(FutureCallback<? super Object> callback, final boolean next) {
            super(callback);

            this.next = next;
        }

        @Override
        public void completed(Object result) {
            if (next) {
                int offsetValue = offset.addAndGet(context.moveExistingBatchSize());
                next(offsetValue);
            } else {
                try {
                    BasicAsyncRequestProducerGenerator generator = SubscriptionsUpdateStatusHandler.updateRequest(context, SubscriptionsUpdateStatusHandler.SUBSCRIPTIONS_SERVICE, itemsList);
                    generator.addHeader(YandexHeaders.SERVICE, SubscriptionsUpdateStatusHandler.SUBSCRIPTIONS_SERVICE);
                    BasicAsyncRequestProducerGenerator fallbackGenerator = SubscriptionsUpdateStatusHandler.updateRequest(context, SubscriptionsUpdateStatusHandler.FALLBACK_SUBSCRIPTIONS_SERVICE, itemsList);
                    fallbackGenerator.addHeader(YandexHeaders.SERVICE, SubscriptionsUpdateStatusHandler.FALLBACK_SUBSCRIPTIONS_SERVICE);

                    SubscriptionsUpdateStatusHandler.store(context, callback,  proxy , generator, fallbackGenerator);
                } catch (BadRequestException | IOException e) {
                    failed(e);
                }
                //callback.completed(null);
            }
        }
    }
}
