package ru.yandex.msearch.proxy.api.async.mail.subscriptions.update;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;

public class FuritaRule implements JsonValue, Comparable<FuritaRule> {
    private final String query;
    private final String id;
    private final int priority;
    private final boolean stop;
    private final List<FuritaAction> actions;

    public FuritaRule(String query, String id, int priority, boolean stop, List<FuritaAction> actions) {
        this.query = query;
        this.id = id;
        this.priority = priority;
        this.stop = stop;
        this.actions = actions;
    }

    public String query() {
        return query;
    }

    public String id() {
        return id;
    }

    public int priority() {
        return priority;
    }

    public boolean stop() {
        return stop;
    }

    public List<FuritaAction> actions() {
        return actions;
    }

    public static FuritaRule parseFromFurita(final JsonMap item) throws JsonException {
        String query = item.getString("query");
        String id = item.getString("id");
        boolean stop = item.getBoolean("stop", false);
        int priority = item.getInt("priority");
        JsonList actionsJsonList = item.getList("actions");
        List<FuritaAction> actions = new ArrayList<>(actionsJsonList.size());
        for (JsonObject actionObj: actionsJsonList) {
            FuritaActionType actionType = actionObj.asMap().getEnum(FuritaActionType.class, "type");

            String parameter =  null;
            switch (actionType) {
                case MOVE:
                case MOVEL:
                case STATUS:
                    parameter = actionObj.asMap().getString("parameter");
                    break;
            }


            actions.add(new FuritaAction(parameter, actionType));
        }

        return new FuritaRule(query, id, priority, stop, actions);
    }

    @Override
    public int compareTo(final FuritaRule o) {
        return Integer.compare(this.priority, o.priority());
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.startObject();
        writer.key("id");
        writer.value(id);
        writer.key("query");
        writer.value(query);
        writer.key("stop");
        writer.value(stop);
        writer.endObject();
    }
}
