package ru.yandex.msearch.proxy.api.async.mail.subscriptions.update;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.client.producer.QueueHostInfo;
import ru.yandex.concurrent.CompletedFuture;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.FilterFutureCallback;
import ru.yandex.http.util.IdempotentFutureCallback;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.msearch.proxy.AsyncHttpServer;
import ru.yandex.msearch.proxy.AsyncHttpServerBase;

public class SequentialMover implements FutureCallback<Object> {
    private final List<UpdateItem> items;
    private final AtomicInteger index = new AtomicInteger(-1);
    private final AtomicInteger completed = new AtomicInteger(0);
    private final FutureCallback<Object> callback;
    private final SubscriptionsUpdateContext context;
    private final AsyncHttpServerBase<?> proxy;

    public SequentialMover(
        final SubscriptionsUpdateContext context,
        final AsyncHttpServerBase<?> server,
        final FutureCallback<Object> callback,
        final List<UpdateItem> items)
    {
        this.items = items;
        this.callback = callback;
        this.context = context;
        this.proxy = server;
    }

    public void launchFirst() {
        if (items.size() <= 0) {
            callback.completed(null);
        } else {
            launchNext();
        }
    }

    public void launchNext() {
        int next = index.incrementAndGet();
        if (next >= items.size()) {
            return;
        }

        context.logger().info("Starting processing " + items.get(next).email());
        try {
            SubscriptionsUpdateStatusHandler.moveExisting(
                new AllMidsMovedCallback(
                    context,
                    new IdempotentFutureCallback<>(this),
                    items.get(next)),
                context,
                proxy,
                items.get(next),
                0);
        } catch (BadRequestException | IOException e) {
            callback.failed(e);
        }
    }

    @Override
    public void completed(final Object o) {
        int cnt = completed.incrementAndGet();
        context.logger().info("Completed " + cnt + "/" + items.size());

        if (cnt < items.size()) {
            launchNext();
        } else {
            callback.completed(o);
        }
    }

    @Override
    public void failed(final Exception e) {
        callback.failed(e);
    }

    @Override
    public void cancelled() {
        callback.cancelled();
    }


    private class AllMidsMovedCallback extends FilterFutureCallback<Object> {
        private final SubscriptionsUpdateContext context;
        private final UpdateItem item;
        private final BasicAsyncRequestProducerGenerator generator;
        private final BasicAsyncRequestProducerGenerator fallbackGenerator;

        public AllMidsMovedCallback(
            final SubscriptionsUpdateContext context,
            final FutureCallback<Object> callback,
            final UpdateItem item)
            throws BadRequestException,IOException
        {
            super(callback);
            this.context = context;
            this.item = item;

            generator = SubscriptionsUpdateStatusHandler.updateRequest(context, SubscriptionsUpdateStatusHandler.SUBSCRIPTIONS_SERVICE, Collections.singletonList(item));
            generator.addHeader(YandexHeaders.SERVICE, SubscriptionsUpdateStatusHandler.SUBSCRIPTIONS_SERVICE);
            fallbackGenerator = SubscriptionsUpdateStatusHandler.updateRequest(context, SubscriptionsUpdateStatusHandler.FALLBACK_SUBSCRIPTIONS_SERVICE, Collections.singletonList(item));
            fallbackGenerator.addHeader(YandexHeaders.SERVICE, SubscriptionsUpdateStatusHandler.FALLBACK_SUBSCRIPTIONS_SERVICE);
        }

        @Override
        public void completed(final Object o) {
            context.logger().info("All mids moved, saving rule");

            SubscriptionsUpdateStatusHandler.store(context, callback, proxy, generator, fallbackGenerator);
        }
    }

}
