package ru.yandex.msearch.proxy.api.async.mail.subscriptions.update;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import org.apache.http.HttpHost;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.MultiFutureCallback;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumerFactory;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.util.string.StringUtils;

public class SubscriptionsFuritaRulesApplier {
    private static final String TRASH = "TRASH";

    private final AsyncClient mopsClient;
    private final HttpHost mopsHost;

    public SubscriptionsFuritaRulesApplier(
        final HttpContext context,
        final AsyncClient mopsClient,
        final HttpHost mopsHost)
    {
        this.mopsClient = mopsClient.adjust(context);
        this.mopsHost = mopsHost;
    }

    private Map<FuritaActionType, Collection<String>> applyForMid(
        final String defaultFid,
        final List<FuritaRule> rules)
    {
        Collections.sort(rules);
        Map<FuritaActionType, Collection<String>> actionToParameter = new LinkedHashMap<>();
        for (FuritaRule rule: rules) {
            for (FuritaAction furitaAction : rule.actions()) {
                //actionToParameter.putIfAbsent(furitaAction., furitaAction);
                if (furitaAction.type() == FuritaActionType.DELETE) {
                    actionToParameter.clear();
                    actionToParameter.put(furitaAction.type(), Collections.singletonList(furitaAction.parameter()));
                    return actionToParameter;
                }

                if (furitaAction.type() == FuritaActionType.MOVE) {
                    actionToParameter.putIfAbsent(
                        furitaAction.type(),
                        Collections.singletonList(furitaAction.parameter()));
                    continue;
                    //fid = furitaAction.parameter();
                    //break;
                }

                if (furitaAction.type() == FuritaActionType.MOVEL) {
                    actionToParameter.computeIfAbsent(furitaAction.type(), (k) -> new LinkedHashSet<>()).add(furitaAction.parameter());
                    continue;
                }

                if (furitaAction.type() == FuritaActionType.STATUS && "RO".equalsIgnoreCase(furitaAction.parameter())) {
                    actionToParameter.putIfAbsent(
                        furitaAction.type(),
                        Collections.singletonList(furitaAction.parameter()));
                    continue;
                }
            }
        }

        actionToParameter.putIfAbsent(FuritaActionType.MOVE, Collections.singleton(defaultFid));
        return actionToParameter;
    }

    public void apply(
        final SubscriptionsUpdateContext context,
        final List<Map.Entry<String, List<FuritaRule>>> mids,
        final FutureCallback<Object> callback)
    {
        String defaultFid = context.inboxFid();

        //Map<String, Map<FuritaActionType, Collection<String>>> actions = new LinkedHashMap<>();
        Map<MopsGroupingKey, List<String>> midByFid = new LinkedHashMap<>();
        for (Map.Entry<String, List<FuritaRule>> entry: mids) {
            Map<FuritaActionType, Collection<String>> result = applyForMid(defaultFid, entry.getValue());
            for (Map.Entry<FuritaActionType, Collection<String>> rEntry: result.entrySet()) {
                MopsGroupingKey key = new MopsGroupingKey(rEntry.getKey(), rEntry.getValue());
                midByFid.computeIfAbsent(key, (k)-> new ArrayList<>()).add(entry.getKey());
            }


//            String fid = defaultFid;
//            for (FuritaRule rule: entry.getValue()) {
//                for (FuritaAction furitaAction: rule.actions()) {
//                    //actionToParameter.putIfAbsent(furitaAction., furitaAction);
//                    if (furitaAction.type() == FuritaActionType.DELETE) {
//                        actionToParameter.clear();
//                        actionToParameter.put(furitaAction.type(), Collections.singletonList(furitaAction));
//                    }
//                    if (furitaAction.type() == FuritaActionType.MOVE) {
//                        actionToParameter.putIfAbsent(furitaAction.type(), Collections.singletonList(furitaAction));
//                        fid = furitaAction.parameter();
//                        //break;
//                    }
//                }
//            }
//
//            midByFid.computeIfAbsent(fid, (k) -> new ArrayList<>(mids.size())).add(entry.getKey());
        }

        MultiFutureCallback<Object> mfcb = new MultiFutureCallback<>(callback);

        try {
            for (Map.Entry<MopsGroupingKey, List<String>> entry: midByFid.entrySet()) {
                StringBuilder midsStr = new StringBuilder(entry.getValue().size() * 20);
                for (String mid: entry.getValue()) {
                    midsStr.append(mid);
                    midsStr.append(',');
                }

                if (midsStr.length() > 0) {
                    midsStr.setLength(midsStr.length() - 1);
                }

                context.logger().info("Batch action " + entry.getKey().type + " mids " + entry.getValue());

                QueryConstructor mopsRequest = null;

                switch (entry.getKey().type) {
                    case DELETE:
                        mopsRequest = new QueryConstructor(
                            "/remove?&subscription_hide_with_remove");
                        mopsRequest.append("nopurge", "1");
                        break;
                    case MOVE:
                        mopsRequest = new QueryConstructor(
                            "/complex_move?&subscription_activate_subs_optin");
                        mopsRequest.append("dest_fid", entry.getKey().params.iterator().next());
                        mopsRequest.append("with_sent", "0");
                        break;
                    case MOVEL:
                        mopsRequest = new QueryConstructor(
                            "/label?&subscription_activate_subs_optin");
                        mopsRequest.append("lids", StringUtils.join(entry.getKey().params, ','));
                        break;
                    case STATUS:
                        mopsRequest = new QueryConstructor(
                            "/mark?&subscription_activate_subs_optin");
                        mopsRequest.append("status", "read");
                        break;
                }

                if (mopsRequest == null) {
                    context.logger().warning("No mopsrequest for " + entry.getKey().type + " " + entry.getValue());
                    continue;
                }

                mopsRequest.append("uid", context.uid());
                mopsRequest.append("request_mids_count", entry.getValue().size());
                mopsRequest.append("source", "mail_search");
                mopsRequest.append("mids", midsStr.toString());

                BasicAsyncRequestProducerGenerator generator =
                    new BasicAsyncRequestProducerGenerator(
                        mopsRequest.toString(),
                        "",
                        ContentType.TEXT_PLAIN);

                generator.addHeader(YandexHeaders.X_REQUEST_ID, context.requestId());

                mopsClient.execute(
                    mopsHost,
                    generator,
                    JsonAsyncTypesafeDomConsumerFactory.OK,
                    context.listener().createContextGeneratorFor(
                        mopsClient),
                    mfcb.newCallback());
            }
        } catch (BadRequestException bre) {
            mfcb.newCallback().failed(bre);
        }

        mfcb.done();
    }

    private static class MopsGroupingKey {
        private final FuritaActionType type;
        private final Collection<String> params;

        public MopsGroupingKey(final FuritaActionType type, final Collection<String> params) {
            this.type = type;
            this.params = params;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            MopsGroupingKey that = (MopsGroupingKey) o;
            return type == that.type && params.equals(that.params);
        }

        @Override
        public int hashCode() {
            return Objects.hash(type, params);
        }
    }
}
