package ru.yandex.msearch.proxy.api.async.mail.subscriptions.update;

import java.util.Set;
import java.util.logging.Logger;

import org.apache.http.Header;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.nio.client.AbstractAsyncClient;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.http.util.nio.client.RequestsListener;
import ru.yandex.http.util.server.HttpServer;
import ru.yandex.mail.search.mail.MailSearchServices;
import ru.yandex.mail.search.subscriptions.SubscriptionsConstants;
import ru.yandex.msearch.proxy.AsyncHttpServerBase;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.search.prefix.LongPrefix;
import ru.yandex.search.proxy.universal.UniversalSearchProxyRequestContext;

public class SubscriptionsUpdateContext implements UniversalSearchProxyRequestContext {
    private final long uid;
    private final User user;
    private final AsyncClient searchClient;
    private final AsyncClient storeClient;
    private final AsyncClient mopsClient;
    private final RequestsListener requestsListener;
    private final Logger logger;
    private final HttpContext httpContext;
    private final String requestId;
    private final boolean moveFromFurita;
    private final int moveExistingBatchSize;
    private final boolean optIn;
    private String inboxFid;
    private String pendingFid;

    public SubscriptionsUpdateContext(
            long uid, User user, AsyncClient searchClient, AsyncClient storeClient,
            AsyncClient mopsClient, RequestsListener requestsListener, Logger logger, HttpContext httpContext,
            String requestId, boolean moveFromFurita, int moveExistingBatchSize, boolean optIn)
    {
        this.uid = uid;
        this.user = user;
        this.searchClient = searchClient;
        this.storeClient = storeClient;
        this.mopsClient = mopsClient;
        this.requestsListener = requestsListener;
        this.logger = logger;
        this.httpContext = httpContext;
        this.requestId = requestId;
        this.moveFromFurita = moveFromFurita;
        this.moveExistingBatchSize = moveExistingBatchSize;
        this.optIn = optIn;
    }

    public static SubscriptionsUpdateContext fromSession(
        final AsyncHttpServerBase<?> proxy,
        final AsyncClient storeClient,
        final ProxySession session)
        throws BadRequestException
    {
        CgiParams params = session.params();
        long uid = params.getLong("uid");
        Header requestIdHeader = session.request().getFirstHeader(YandexHeaders.X_REQUEST_ID);
        String requestId;
        if (requestIdHeader != null) {
            requestId = requestIdHeader.getValue();
        } else {
            String sessionId =
                    (String) session.context().getAttribute(HttpServer.SESSION_ID);
            requestId = session.params().getString("request_id", sessionId);
        }
        return new SubscriptionsUpdateContext(
                uid,
                new User(MailSearchServices.CHANGE_LOG.service(), new LongPrefix(uid)),
                proxy.searchClient().adjust(session.context()),
                storeClient.adjust(session.context()),
                proxy.mopsClient() == null
                        ? null
                        : proxy.mopsClient().adjust(session.context()),
                session.listener(),
                session.logger(),
                session.context(),
                requestId,
                session.params().getBoolean("move_from_furita", false),
                session.params().getInt("move_existing_batch_size", 200),
                params.getBoolean("opt_in_subs", false)
        );
    }

    public AsyncClient mopsClient() {
        return mopsClient;
    }

    public String requestId() {
        return requestId;
    }

    public int moveExistingBatchSize() {
        return moveExistingBatchSize;
    }

    public boolean moveFromFurita() {
        return moveFromFurita;
    }


    public RequestsListener listener() {
        return requestsListener;
    }

    public AsyncClient storeClient() {
        return storeClient;
    }

    public boolean optIn() {
        return optIn;
    }

    public Set<String> types() {
        if (optIn) {
            return SubscriptionsConstants.OPT_IN_TYPES;
        } else {
            return SubscriptionsConstants.TYPES;
        }
    }

    public synchronized SubscriptionsUpdateContext inboxFid(final String inboxFid) {
        this.inboxFid = inboxFid;
        return this;
    }

    public synchronized SubscriptionsUpdateContext pendingFid(final String pendingFid) {
        this.pendingFid = pendingFid;
        return this;
    }

    public synchronized String inboxFid() {
        return inboxFid;
    }

    public synchronized String pendingFid() {
        return pendingFid;
    }

    @Override
    public User user() {
        return user;
    }

    @Override
    public Long minPos() {
        return null;
    }

    @Override
    public AbstractAsyncClient<?> client() {
        return searchClient;
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public long lagTolerance() {
        return 0L;
    }

    public AsyncClient searchClient() {
        return searchClient;
    }

    public long uid() {
        return uid;
    }

    public HttpContext httpContext() {
        return httpContext;
    }
}
