package ru.yandex.msearch.proxy.api.async.mail.subscriptions.update;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import ru.yandex.msearch.proxy.api.async.mail.subscriptions.SubscriptionStatus;

public enum UpdateAction {
    ACTIVATE("activate", SubscriptionStatus.ACTIVE),
    ACTIVATE_NEW("activate_new", SubscriptionStatus.ACTIVE),
    HIDE("hide", SubscriptionStatus.HIDDEN),
    HIDDEN("hidden", SubscriptionStatus.HIDDEN);

    private final String value;
    private final SubscriptionStatus target;

    private static final Map<String, UpdateAction> map =
            Arrays.stream(UpdateAction.values())
                    .collect(Collectors.toMap(UpdateAction::value, Function.identity()));


    UpdateAction(String value, final SubscriptionStatus target) {
        this.value = value;
        this.target = target;
    }

    public SubscriptionStatus target() {
        return target;
    }

    public String value() {
        return value;
    }

    public static UpdateAction of(String value) {
        if (!map.containsKey(value)) {
            throw new RuntimeException("Incorrect status value: " + value);
        }
        return map.get(value);
    }
}
