package ru.yandex.msearch.proxy.api.async.mail.subscriptions.update;

import java.io.IOException;
import java.util.Set;

import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.msearch.proxy.api.async.mail.subscriptions.SubscriptionStatus;
import ru.yandex.parser.string.ValuesStorage;
import ru.yandex.util.string.StringUtils;

public class UpdateItem implements JsonValue {
    private final Set<String> types;
    private final String email;
    private final boolean moveExisting;
    private final UpdateAction action;
    private final long uid;
    private final SubscriptionsUpdateContext context;

    public UpdateItem(Set<String> types, String email, boolean moveExisting, UpdateAction action, long uid,
                      SubscriptionsUpdateContext context) {
        this.types = types;
        this.email = email;
        this.moveExisting = moveExisting;
        this.action = action;
        this.uid = uid;
        this.context = context;
    }

    public static <E extends Exception> UpdateItem fromMap(
            ValuesStorage<E> map,
            SubscriptionsUpdateContext context)
            throws E
    {
        UpdateAction updateAction =
                map.getEnum(UpdateAction.class, "action", null);
        if (updateAction == null) {
            SubscriptionStatus status = map.getEnum(SubscriptionStatus.class, "status", SubscriptionStatus.HIDDEN);
            if (status == SubscriptionStatus.HIDDEN) {
                updateAction = UpdateAction.HIDE;
            } else {
                updateAction = UpdateAction.ACTIVATE;
            }
        }
        return new UpdateItem(
                map.get("types", context.types(), SubscriptionsUpdateStatusHandler.SET_PARSER),
                map.getString("email"),
                map.getBoolean("move_existing", false),
                updateAction,
                context.uid(),
                context
        );
    }


    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.startObject();
        writer.key("url");
        writer.value("subs_" + this.uid + "_" + this.email);

        if (action == UpdateAction.HIDE) {
            writer.key(ru.yandex.ps.mail.search.SubscriptionsFields.SUBS_HIDDEN_TYPES.stored());
            writer.value(StringUtils.join(types, '\n'));
            writer.key(ru.yandex.ps.mail.search.SubscriptionsFields.SUBS_OPTIN_ACTIVE_TYPES.stored());
            writer.nullValue();
        } else if (action == UpdateAction.ACTIVATE_NEW) {
            writer.key(ru.yandex.ps.mail.search.SubscriptionsFields.SUBS_HIDDEN_TYPES.stored());
            writer.nullValue();
            writer.key(ru.yandex.ps.mail.search.SubscriptionsFields.SUBS_OPTIN_ACTIVE_TYPES.stored());
            writer.value(StringUtils.join(types, '\n'));
        } else if (action == UpdateAction.ACTIVATE) {
            if (context.optIn()) {
                writer.key(ru.yandex.ps.mail.search.SubscriptionsFields.SUBS_OPTIN_ACTIVE_TYPES.stored());
                writer.value(StringUtils.join(types, '\n'));
            }
            writer.key(ru.yandex.ps.mail.search.SubscriptionsFields.SUBS_HIDDEN_TYPES.stored());
            writer.nullValue();
        }

        writer.key(ru.yandex.ps.mail.search.SubscriptionsFields.SUBS_EMAIL.stored());
        writer.value(email);
        writer.endObject();
    }

    public boolean moveExisting() {
        return moveExisting;
    }

    public Set<String> types() {
        return types;
    }

    public String email() {
        return email;
    }

    public UpdateAction action() {
        return action;
    }

    public long uid() {
        return uid;
    }
}
