package ru.yandex.msearch.proxy.api.async.mail.subscriptions.update;

import java.io.IOException;
import java.util.Map;

import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;

public class UserFuritaRules implements JsonValue {
    private final Map<String, FuritaRule> rules;

    public UserFuritaRules(Map<String, FuritaRule> rules) {
        this.rules = rules;
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.startArray();
        for (Map.Entry<String, FuritaRule> entry: rules.entrySet()) {
            writer.value(entry.getValue());
        }
        writer.endArray();
    }

    public FuritaRule get(final String id) {
        return rules.get(id);
    }

    public Map<String, FuritaRule> rules() {
        return rules;
    }
}
