package ru.yandex.msearch.proxy.api.async.mail.subscriptions.update.dao.pojo;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

import ru.yandex.msearch.proxy.api.async.mail.subscriptions.update.SubscriptionsUpdateContext;
import ru.yandex.msearch.proxy.api.async.mail.subscriptions.update.UpdateAction;
import ru.yandex.msearch.proxy.api.async.mail.subscriptions.update.UpdateItem;

public class MigrationTask {
    private final long timestamp;
    private final long uid;
    private final String email;
    private final String action;
    private final String status;
    private final String requestId;
    private final boolean optIn;
    private final String types; // comma separated
    private final long lastUpdate;
    private final int retryCount;

    public MigrationTask(
            long timestamp,
            long uid,
            String email,
            String action,
            String status,
            String requestId,
            boolean optIn,
            String types,
            long lastUpdate,
            int retryCount)
    {
        this.timestamp = timestamp;
        this.uid = uid;
        this.email = email;
        this.action = action;
        this.status = status;
        this.requestId = requestId;
        this.optIn = optIn;
        this.types = types;
        this.lastUpdate = lastUpdate;
        this.retryCount = retryCount;
    }

    public long getTimestamp() {
        return timestamp;
    }

    public long getUid() {
        return uid;
    }

    public String getEmail() {
        return email;
    }

    public UpdateAction getAction() {
        return UpdateAction.of(action);
    }

    public MigrationTaskStatus getStatus() {
        return MigrationTaskStatus.of(status);
    }

    public boolean isOptIn() {
        return optIn;
    }

    public String getRequestId() {
        return requestId;
    }

    public Set<String> getTypes() {
        return Arrays.stream(types.split(",")).collect(Collectors.toSet());
    }

    public long getLastUpdate() {
        return lastUpdate;
    }

    public int getRetryCount() {
        return retryCount;
    }

    public UpdateItem toUpdateItem(SubscriptionsUpdateContext context) {
        return new UpdateItem(
                getTypes(),
                email,
                true,
                getAction(),
                uid,
                context
        );
    }

    public static MigrationTask fromUpdateItem(UpdateItem item, SubscriptionsUpdateContext context) {
        return new MigrationTask(
                System.currentTimeMillis(),
                context.uid(),
                item.email(),
                item.action().value(),
                MigrationTaskStatus.CREATED.value(),
                context.requestId(),
                context.optIn(),
                String.join(",", item.types()),
                System.currentTimeMillis(),
                0
        );
    }
}
