package ru.yandex.msearch.proxy.api.async.mail.subscriptions.update.dao.pojo;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum MigrationTaskStatus {
    CREATED("created"),
    RUNNING("running"),
    FINISHED("finished"),
    FAILED("failed");

    private final String value;

    private static final Map<String, MigrationTaskStatus> map =
            Arrays.stream(MigrationTaskStatus.values())
                    .collect(Collectors.toMap(MigrationTaskStatus::value, Function.identity()));

    MigrationTaskStatus(String value) {
        this.value = value;
    }

    public String value() {
        return value;
    }

    public static MigrationTaskStatus of(String value) {
        if (!map.containsKey(value)) {
            throw new RuntimeException("Incorrect status value: " + value);
        }
        return map.get(value);
    }
}
