package ru.yandex.msearch.proxy.api.async.mail.tabs.category;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class Categories {
    private static final Function<String, Set<String>> LIST_FACTORY =
        k -> new LinkedHashSet<>();
    private final Map<String, Set<String>> categoriesMap;

    public Categories() {
        this.categoriesMap = new LinkedHashMap<>();
    }

    public void add(final String mid, final String category) {
        categoriesMap.computeIfAbsent(mid, LIST_FACTORY).add(category);
    }

    public Map<String, Set<String>> categories() {
        return categoriesMap;
    }
}
