package ru.yandex.msearch.proxy.api.async.mail.tabs.category;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.CodingErrorAction;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NByteArrayEntity;
import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.NByteArrayEntityFactory;
import ru.yandex.io.DecodableByteArrayOutputStream;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;

public class CategoriesPrinter
    extends AbstractProxySessionCallback<Map<String, List<String>>>
{
    private final JsonType jsonType;

    public CategoriesPrinter(
        final ProxySession session)
        throws BadRequestException
    {
        super(session);

        this.jsonType = JsonTypeExtractor.NORMAL.extract(session.params());
    }

    @Override
    public void completed(final Map<String, List<String>> categories) {
        DecodableByteArrayOutputStream out =
            new DecodableByteArrayOutputStream();
        try (OutputStreamWriter outWriter =
                 new OutputStreamWriter(
                     out,
                     session.acceptedCharset().newEncoder()
                         .onMalformedInput(CodingErrorAction.REPLACE)
                         .onUnmappableCharacter(CodingErrorAction.REPLACE));
             JsonWriter writer = jsonType.create(outWriter))
        {
            writer.value(categories);
        } catch (IOException e) {
            failed(e);
            return;
        }

        NByteArrayEntity entity =
            out.processWith(NByteArrayEntityFactory.INSTANCE);
        entity.setContentType(
            ContentType.APPLICATION_JSON.withCharset(
                session.acceptedCharset())
                .toString());
        session.response(HttpStatus.SC_OK, entity);
    }
}
