package ru.yandex.msearch.proxy.api.async.mail.tabs.category;

import java.util.List;
import java.util.function.Function;

import org.apache.http.HttpHost;

import org.apache.http.concurrent.FutureCallback;

import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.proxy.ProxySession;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.msearch.proxy.AsyncHttpServer;
import ru.yandex.msearch.proxy.api.async.mail.searcher.AbstractPlainSearcher;
import ru.yandex.msearch.proxy.api.async.mail.searcher
    .StrictPositionSearcherCallback;

import ru.yandex.parser.searchmap.User;

import ru.yandex.search.proxy.SearchResultConsumerFactory;

import ru.yandex.search.result.SearchResult;

public class PositionPlainSearcher
    extends AbstractPlainSearcher<SearchResult>
{
    protected final AsyncHttpServer server;
    protected final User user;
    protected final long position;

    public PositionPlainSearcher(
        final AsyncHttpServer server,
        final ProxySession session,
        final User user,
        final long position)
        throws BadRequestException
    {
        super(session, server.searchClient(), null);

        this.server = server;
        this.user = user;
        this.position = position;
    }

    protected FutureCallback<SearchResult> positionCallback(
        final FutureCallback<SearchResult> callback,
        final List<HttpHost> hosts)
    {
        return new StrictPositionSearcherCallback(
            callback,
            logger(),
            position,
            hosts.size());
    }

    @Override
    public void search(
        final Function<? super HttpHost, ? extends HttpAsyncRequestProducer>
            request,
        final FutureCallback<SearchResult> callback)
    {
        List<HttpHost> hosts = hosts(server.searchMap(), user);

        FutureCallback<SearchResult> posCallback =
            positionCallback(callback, hosts);

        for (int i = hosts.size(); i-- > 0;) {
            searchClient.execute(
                hosts.get(i),
                request,
                SearchResultConsumerFactory.OK,
                listener().createContextGeneratorFor(searchClient),
                posCallback);
        }
    }
}
