package ru.yandex.msearch.proxy.api.async.mail.tabs.content;

import org.apache.http.HttpException;
import ru.yandex.http.util.BadRequestException;

import ru.yandex.msearch.proxy.api.async.mail.SearchRequest;
import ru.yandex.msearch.proxy.api.async.mail.SearchSession;

import ru.yandex.msearch.proxy.api.async.mail.rules.AbstractPlainSearchCallback;

import ru.yandex.msearch.proxy.api.async.mail.rules.PlainSearchRule;
import ru.yandex.msearch.proxy.api.async.mail.rules.RuleContext;

public class TabsPlainSearchRule extends PlainSearchRule {
    public TabsPlainSearchRule(final RuleContext context) {
        super(context);
    }

    @Override
    protected AbstractPlainSearchCallback createCallback(
        final SearchSession session,
        final SearchRequest request)
        throws BadRequestException
    {
        return new TabsSearchCallback(
            session,
            context,
            request);
    }
}
