package ru.yandex.msearch.proxy.api.async.mail.tabs.content;

import java.util.Collections;

import org.apache.http.HttpException;
import ru.yandex.client.wmi.Labels;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.msearch.proxy.api.async.mail.SearchSession;
import ru.yandex.msearch.proxy.api.async.mail.rules.SearchRule;

public class TabsRewriteRequestRule implements SearchRule {
    private static final Labels EMPTY_LABELS =
        new Labels(Collections.emptyMap(), "None", "None");

    private final SearchRule next;

    public TabsRewriteRequestRule(
        final SearchRule next)
    {
        this.next = next;
    }

    @Override
    public void execute(final SearchSession session)
        throws HttpException
    {
        String filter = session.params().getString("tab");
        final String filterRequest =
            session.httpSession().server().config().filtersConfig()
                .filters().get(filter).apply(EMPTY_LABELS);

        if (filterRequest == null) {
            throw new BadRequestException(
                "Invalid &search-filter parameter: unknown filter name <"
                    + filter + '>');
        }

        session.params().put(
            "request",
            Collections.singletonList(filterRequest));

        this.next.execute(session);
    }
}
