package ru.yandex.msearch.proxy.api.async.mail.tabs.count;

import java.util.Collections;

import org.apache.http.concurrent.FutureCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.search.rules.BasicRequestParams;
import ru.yandex.search.rules.RequestParams;
import ru.yandex.search.rules.SearchInfo;
import ru.yandex.search.rules.SearchService;

public class CountSearchService
    implements SearchService<DocumentsCount, RequestParams, SearchInfo>
{
    @Override
    public RequestParams createRequestParams(
        final ProxySession session)
        throws BadRequestException
    {
        return new BasicRequestParams(0, 0, Collections.emptySet());
    }

    @Override
    public SearchInfo createSearchInfo(
        final ProxySession session,
        final RequestParams params)
        throws BadRequestException
    {
        return new SearchInfo("");
    }

    @Override
    public FutureCallback<? super DocumentsCount> createCallback(
        final ProxySession session,
        final RequestParams requestParams,
        final SearchInfo searchInfo)
        throws BadRequestException
    {
        return new FilterCountPrinter(session);
    }
}
