package ru.yandex.msearch.proxy.api.async.mail.tabs.count;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;

import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;

import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;

import ru.yandex.msearch.proxy.AsyncHttpServer;

import ru.yandex.search.rules.BasicSearchRequest;
import ru.yandex.search.rules.RequestParams;
import ru.yandex.search.rules.ResolveUserRule;
import ru.yandex.search.rules.SearchInfo;
import ru.yandex.search.rules.SearchRequest;
import ru.yandex.search.rules.SearchRule;

public class FilterCountHandler
    implements HttpAsyncRequestHandler<HttpRequest>
{
    private final AsyncHttpServer server;
    private final SearchRule<DocumentsCount, RequestParams, SearchInfo> rule;

    public FilterCountHandler(final AsyncHttpServer server) {
        this.server = server;

        SearchRule<DocumentsCount, RequestParams, SearchInfo> rule =
            new FilterCountSearchRule(server);
        this.rule = new ResolveUserRule<>(rule, server::blackboxClient);
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(
        final HttpRequest httpRequest,
        final HttpContext httpContext)
        throws HttpException, IOException
    {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException, IOException
    {
        ProxySession session = new BasicProxySession(server, exchange, context);
        CountSearchService service = new CountSearchService();

        SearchRequest<DocumentsCount, RequestParams, SearchInfo> sr =
            new BasicSearchRequest<>(session, service);

        rule.execute(sr);
    }
}
