package ru.yandex.msearch.proxy.api.async.mail.usertype;

import java.util.logging.Level;

import org.apache.http.HttpStatus;
import org.apache.http.concurrent.FutureCallback;
import ru.yandex.http.util.HttpExceptionConverter;
import ru.yandex.msearch.proxy.api.async.Session;

public class UserTypeChangeCallback implements FutureCallback<Object> {
    private final Session session;

    public UserTypeChangeCallback(final Session session) {
        this.session = session;
    }

    @Override
    public void completed(final Object o) {
        session.response(HttpStatus.SC_OK);
    }

    @Override
    public void failed(final Exception e) {
        session.logger().log(
            Level.WARNING,
            "Request failed: \n" + session.requestsListener().details(),
            e);

        session.handleException(HttpExceptionConverter.toHttpException(e));
    }

    @Override
    public void cancelled() {
        session.logger().warning("Request cancelled: ");
    }
}
