package ru.yandex.msearch.proxy.api.async.mail.usertype;

import java.io.IOException;
import java.util.List;

import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;

import org.apache.http.entity.ContentType;

import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;

import org.apache.http.protocol.HttpContext;

import ru.yandex.dbfields.ChangeType;
import ru.yandex.dbfields.MailIndexFields;
import ru.yandex.dbfields.OracleFields;
import ru.yandex.dbfields.PgFields;

import ru.yandex.http.util.BadRequestException;

import ru.yandex.http.util.MultiFutureCallback;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.BasicAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.client.AbstractAsyncClient;

import ru.yandex.io.StringBuilderWriter;

import ru.yandex.json.writer.JsonWriter;

import ru.yandex.msearch.proxy.AsyncHttpServer;

import ru.yandex.msearch.proxy.api.async.BasicSession;
import ru.yandex.msearch.proxy.api.async.ProxyParams;
import ru.yandex.msearch.proxy.api.async.Session;

import ru.yandex.parser.email.MailAliases;

import ru.yandex.parser.searchmap.User;

import ru.yandex.parser.uri.CgiParams;
import ru.yandex.parser.uri.QueryConstructor;

import ru.yandex.search.prefix.Prefix;
import ru.yandex.search.prefix.PrefixType;

public class UserTypeChangeHandler
    implements HttpAsyncRequestHandler<HttpRequest>
{
    private final AsyncHttpServer server;
    private final AbstractAsyncClient<?> producerClient;
    private final HttpHost producerHost;

    public UserTypeChangeHandler(final AsyncHttpServer server) {
        this.server = server;

        this.producerClient = server.producerClient();
        if (server.config().producerClientConfig() != null) {
            this.producerHost = server.config().producerClientConfig().host();
        } else {
            this.producerHost = null;
        }
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(
        final HttpRequest httpRequest,
        final HttpContext httpContext)
        throws HttpException, IOException
    {
        return new BasicAsyncRequestConsumer();
    }

    private User user(final CgiParams params)
        throws BadRequestException
    {
        String mdb = params.getString(ProxyParams.MDB);
        PrefixType prefixType = server.searchMap().prefixType(mdb);

        Prefix prefix;
        if (mdb.equals("pg")) {
            prefix = params.get(ProxyParams.UID, prefixType);
        } else {
            prefix = params.get(ProxyParams.SUID, prefixType);
        }

        return new User(
            AsyncHttpServer.resolveService(mdb, prefix, server.config()),
            prefix);
    }

    private String buildNotifyData(
        final User user,
        final String from,
        final String userType)
        throws IOException
    {
        StringBuilderWriter sbWriter = new StringBuilderWriter();
        JsonWriter writer = new JsonWriter(sbWriter);
        writer.startObject();
        writer.key(PgFields.UID);
        writer.value(user.prefix());
        writer.key(OracleFields.LCN);
        writer.value(-1);
        writer.key(PgFields.CHANGE_TYPE);
        writer.value(ChangeType.USER_TYPE_UPDATE);
        writer.key("operation_date");
        writer.value(System.currentTimeMillis());
        writer.key(MailIndexFields.HDR + MailIndexFields.FROM);
        writer.value(from);
        writer.key("userType");
        writer.value(userType);

        writer.endObject();
        writer.close();

        return sbWriter.toString();
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException, IOException
    {
        if (producerHost == null) {
            throw new BadRequestException("No producer setting");
        }

        Session httpSession = new BasicSession(server, exchange, context);
        UserTypeChangeCallback callback =
            new UserTypeChangeCallback(httpSession);

        CgiParams params = new CgiParams(request);

        List<String> froms = params.getAll("from");
        if (froms.size() <= 0) {
            throw new BadRequestException("No email specified");
        }

        String targetType = params.getString("target");

        MultiFutureCallback<Object> mfcb =
            new MultiFutureCallback<>(callback);

        User user = user(params);

        QueryConstructor baseUri = new QueryConstructor("/notify?");
        baseUri.append("prefix", user.prefix().toString());
        baseUri.append("service", user.service());
        baseUri.append("mdb", params.getString("mdb"));
        baseUri.append("uid", params.getString("uid"));
        baseUri.append("msproxy", "utype_change_reindex");

        AbstractAsyncClient<?> client =
            producerClient.adjust(httpSession.context());

        for (String from: froms) {
            from =  MailAliases.INSTANCE.normalizeEmail(from);
            QueryConstructor uri = new QueryConstructor(baseUri.toString());
            uri.append("email", from);

            client.execute(
                producerHost,
                new BasicAsyncRequestProducerGenerator(
                    uri.toString(),
                    buildNotifyData(user, from, targetType),
                    ContentType.APPLICATION_JSON),
                BasicAsyncResponseConsumerFactory.OK,
                mfcb.newCallback());
        }

        mfcb.done();
    }
}
