package ru.yandex.msearch.proxy.api.async.senders;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.CodingErrorAction;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpStatus;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NByteArrayEntity;

import ru.yandex.charset.StreamEncoder;
import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.nio.NByteArrayEntityFactory;
import ru.yandex.io.DecodableByteArrayOutputStream;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.search.result.SearchDocument;
import ru.yandex.search.result.SearchResult;

public class ResultPrinter
    extends AbstractProxySessionCallback
        <Map.Entry<List<SendersRequestWithResponse>, SearchResult>>
{
    private final JsonType jsonType;

    public ResultPrinter(final ProxySession session, final JsonType jsonType) {
        super(session);
        this.jsonType = jsonType;
    }

    @Override
    public void completed(
        final Map.Entry<List<SendersRequestWithResponse>, SearchResult> result)
    {
        List<SendersRequestWithResponse> results = result.getKey();
        List<SearchDocument> senderFeaturesDocs = result.getValue().hitsArray();
        DecodableByteArrayOutputStream out =
            new DecodableByteArrayOutputStream();
        try (JsonWriter writer =
                jsonType.create(
                    new StreamEncoder(
                        out,
                        session.acceptedCharset().newEncoder()
                            .onMalformedInput(CodingErrorAction.REPLACE)
                            .onUnmappableCharacter(
                                CodingErrorAction.REPLACE))))
        {
            writer.startObject();
            writer.key("results");
            writer.startArray();
            int size = results.size();
            for (int i = 0; i < size; ++i) {
                results.get(i).writeValue(writer);
            }
            writer.endArray();
            if (senderFeaturesDocs.size() > 0) {
                SearchDocument doc = senderFeaturesDocs.get(0);
                String features = doc.attrs().get("user_ml_features");
                if (features != null) {
                    writer.key("sender_ml_features");
                    writer.value(features);
                }
                String embeddings = doc.attrs().get("user_ml_embeddings");
                if (embeddings != null) {
                    writer.key("sender_ml_embeddings");
                    writer.value(embeddings);
                }
            }
            writer.endObject();
        } catch (IOException e) {
            failed(e);
            return;
        }
        NByteArrayEntity entity =
            out.processWith(NByteArrayEntityFactory.INSTANCE);
        entity.setContentType(
            ContentType.APPLICATION_JSON.withCharset(
                session.acceptedCharset())
                .toString());
        session.response(HttpStatus.SC_OK, entity);
    }
}
