package ru.yandex.msearch.proxy.api.async.senders;

import ru.yandex.json.dom.JsonNull;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.JsonString;
import ru.yandex.parser.mail.senders.SenderType;
import ru.yandex.parser.mail.senders.SendersContext;
import ru.yandex.search.result.BasicSearchDocument;
import ru.yandex.search.result.SearchDocument;
import ru.yandex.search.result.SearchResult;

public class SendersDocs {
    private static final SearchDocument EMPTY_DOC =
        new BasicSearchDocument();

    private static final String PRIMARY_KEY = "url";

    private final SearchDocument sendersDoc;
    private final SenderType senderType;
    private final SearchDocument domainSendersDoc;
    private final SenderType domainSenderType;
    private final SearchDocument pfiltersDoc;
    private final SenderType pfiltersSenderType;
    private final SearchDocument tabPfDoc;
    private final SenderType tabPfSenderType;
    private final JsonObject userMlFeatures;
    private final JsonObject userMlEmbeddings;
    private final boolean inReplyToMatches;
    private final boolean referencesMatches;

    public SendersDocs(
        final SearchResult senders,
        final SearchResult inReplyTo,
        final SearchResult references)
    {
        SearchDocument sendersDoc = EMPTY_DOC;
        SenderType senderType = null;
        SearchDocument domainSendersDoc = EMPTY_DOC;
        SenderType domainSenderType = null;
        SearchDocument pfiltersDoc = EMPTY_DOC;
        SenderType pfiltersSenderType = null;
        SearchDocument tabPfDoc = EMPTY_DOC;
        SenderType tabPfSenderType = null;
        JsonObject userMlFeatures = JsonNull.INSTANCE;
        JsonObject userMlEmbeddings = JsonNull.INSTANCE;
        for (SearchDocument doc : senders.hitsArray()) {
            final String primaryKey = doc.attrs().get(PRIMARY_KEY);
            if (primaryKey.startsWith("senders_domain_")) {
                SenderType type =
                    SendersContext.detectSenderDomainType(primaryKey);
                if (upgradeSenderType(domainSenderType, type)) {
                    domainSenderType = type;
                    domainSendersDoc = doc;
                }
            } else if (primaryKey.startsWith("senders_")) {
                SenderType type = SendersContext.detectSenderType(primaryKey);
                if (upgradeSenderType(senderType, type)) {
                    senderType = type;
                    sendersDoc = doc;
                }
            } else if (primaryKey.startsWith("pfilters4_")) {
                SenderType type = SendersContext.detectPfilterType(primaryKey);
                if (upgradeSenderType(pfiltersSenderType, type)) {
                    pfiltersSenderType = type;
                    pfiltersDoc = doc;
                }
            } else if (primaryKey.startsWith("tabpf_")) {
                SenderType type = SendersContext.detectTabPfType(primaryKey);
                if (upgradeSenderType(tabPfSenderType, type)) {
                    tabPfSenderType = type;
                    tabPfDoc = doc;
                }
            } else if (primaryKey.startsWith("user_ml_features_uid_")) {
                String features = doc.attrs().get("user_ml_features");
                if (features != null) {
                    userMlFeatures = new JsonString(features);
                }
                String embeddings = doc.attrs().get("user_ml_embeddings");
                if (embeddings != null) {
                    userMlEmbeddings = new JsonString(embeddings);
                }
            }
        }

        this.sendersDoc = sendersDoc;
        this.senderType = senderType;
        this.domainSendersDoc = domainSendersDoc;
        this.domainSenderType = domainSenderType;
        this.pfiltersDoc = pfiltersDoc;
        this.pfiltersSenderType = pfiltersSenderType;
        this.tabPfDoc = tabPfDoc;
        this.tabPfSenderType = tabPfSenderType;
        this.userMlFeatures = userMlFeatures;
        this.userMlEmbeddings = userMlEmbeddings;
        inReplyToMatches = inReplyTo.hitsCount() > 0L;
        referencesMatches = references.hitsCount() > 0L;
    }

    private static boolean upgradeSenderType(
        final SenderType currentType,
        final SenderType newType)
    {
        return newType != null
            && (currentType == null || newType.compareTo(currentType) < 0);
    }

    public SearchDocument sendersDoc() {
        return sendersDoc;
    }

    public SenderType senderType() {
        return senderType;
    }

    public SearchDocument domainSendersDoc() {
        return domainSendersDoc;
    }

    public SenderType domainSenderType() {
        return domainSenderType;
    }

    public SearchDocument pfiltersDoc() {
        return pfiltersDoc;
    }

    public SenderType pfiltersSenderType() {
        return pfiltersSenderType;
    }

    public SearchDocument tabPfDoc() {
        return tabPfDoc;
    }

    public SenderType tabPfSenderType() {
        return tabPfSenderType;
    }

    public JsonObject userMlFeatures() {
        return userMlFeatures;
    }

    public JsonObject userMlEmbeddings() {
        return userMlEmbeddings;
    }

    public boolean inReplyToMatches() {
        return inReplyToMatches;
    }

    public boolean referencesMatches() {
        return referencesMatches;
    }
}
