package ru.yandex.msearch.proxy.api.async.senders;

import java.io.IOException;

import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;

public class SendersRequestWithResponse implements JsonValue {
    private final SendersRequest request;
    private final SendersResponse response;

    public SendersRequestWithResponse(
        final SendersRequest request,
        final SendersResponse response)
    {
        this.request = request;
        this.response = response;
    }

    public SendersRequest request() {
        return request;
    }

    public SendersResponse response() {
        return response;
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.startObject();
        writer.key("request");
        request.writeValue(writer);
        writer.key("response");
        response.writeValue(writer);
        writer.endObject();
    }
}
