package ru.yandex.msearch.proxy.api.async.so;

import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.parser.email.MailAliases;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.PositiveLongValidator;
import ru.yandex.search.prefix.LongPrefix;
import ru.yandex.url.processor.CommonZoneExtractor;

public class DkimStatsSelector {
    public static final long TIMESTAMP_GRANULARITY = 86400L;
    public static final int DEFAULT_DAYS_COUNT = 15;
    public static final int DEFAULT_TOP_DOMAINS_COUNT = 3;

    private final String from;
    private final LongPrefix prefix;
    private final long timestamp;
    private final long day;
    private final Set<String> dkimDomains;

    public DkimStatsSelector(final ProxySession session) throws HttpException {
        from =
            MailAliases.INSTANCE.normalizeEmail(
                session.params().get("from", NonEmptyValidator.TRIMMED));
        prefix = new LongPrefix(from.hashCode() & 0xffffffffL);

        timestamp =
            session.params().get("timestamp", PositiveLongValidator.INSTANCE);
        day = timestamp / TIMESTAMP_GRANULARITY;

        dkimDomains =
            session.params().getAll(
                "dkim-domain",
                Collections.emptySet(),
                NonEmptyValidator.INSTANCE.andThen(
                    x -> x.toLowerCase(Locale.ROOT))
                    .andThen(CommonZoneExtractor.INSTANCE),
                new HashSet<>());

        session.logger().fine(
            "From normalized to " + from
            + ", prefix: " + prefix
            + ", timestamp: " + timestamp
            + ", dkim domains: " + dkimDomains);
    }

    public String from() {
        return from;
    }

    public LongPrefix prefix() {
        return prefix;
    }

    public long timestamp() {
        return timestamp;
    }

    public long day() {
        return day;
    }

    public Set<String> dkimDomains() {
        return dkimDomains;
    }
}

