package ru.yandex.msearch.proxy.api.async.so;

import java.io.IOException;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumerFactory;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.msearch.proxy.AsyncHttpServer;
import ru.yandex.msearch.proxy.api.async.BasicSession;
import ru.yandex.msearch.proxy.api.async.Session;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.prefix.LongPrefix;
import ru.yandex.search.proxy.universal.PlainUniversalSearchProxyRequestContext;

public class GetUserWeights
    implements HttpAsyncRequestHandler<HttpRequest> {

    public static final int COMPAINS_UID = 991949281;
    public static final String FIELD_PREF = "uw_";

    private final AsyncHttpServer server;

    public GetUserWeights(AsyncHttpServer server) {
        this.server = server;
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(
        final HttpRequest httpRequest,
        final HttpContext httpContext)
    {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public void handle(
        HttpRequest request,
        HttpAsyncExchange exchange,
        HttpContext context)
        throws HttpException, IOException
    {
        Session httpSession = new BasicSession(server, exchange, context);
        String validUntilRaw = httpSession.params().getOrNull("valid_until");
        final Integer validUntil;
        if (validUntilRaw == null) {
            validUntil = null;
        } else if ("now".equals(validUntilRaw)) {
            validUntil = Math.toIntExact(System.currentTimeMillis() / 1000L);
        } else {
            validUntil = Integer.valueOf(validUntilRaw);
        }

        QueryConstructor query = new QueryConstructor("/search?", false);
        query.append("prefix", COMPAINS_UID);
        query.append("get", "*");
        query.append("sort", "url");
        query.append("skip-nulls", "true");
        query.append("json-type", "dollar");
        query.append("text", "url:" + "so_user_weight_" + COMPAINS_UID + "_*");

        AsyncClient client =
            httpSession.server().searchClient().adjust(httpSession.context());
        httpSession.server().sequentialRequest(
            httpSession,
            new PlainUniversalSearchProxyRequestContext(
                new User(
                    httpSession.server().config().pgQueue(),
                    new LongPrefix(COMPAINS_UID)),
                null,
                true,
                client,
                httpSession.logger()),
            new BasicAsyncRequestProducerGenerator(query.toString()),
            httpSession.server().config().failoverSearchDelay(),
            false,
            JsonAsyncTypesafeDomConsumerFactory.OK,
            httpSession.listener().createContextGeneratorFor(client),
            new ReplyingCallback(httpSession, validUntil));

    }

    private static class ReplyingCallback
        extends AbstractProxySessionCallback<JsonObject>
    {
        private final Integer queryTime;

        public ReplyingCallback(ProxySession session, Integer queryTime) {
            super(session);
            this.queryTime = queryTime;
        }

        @Override
        public void completed(JsonObject jsonObject) {
            JsonList results = new JsonList(BasicContainerFactory.INSTANCE);
            try {
                for(JsonObject doc : jsonObject.get("hitsArray").asList()) {
                    if (queryTime == null ||
                        doc.get("uw_valid_until").asLong() >= queryTime) {
                        JsonMap resDoc =
                            new JsonMap(BasicContainerFactory.INSTANCE);
                        for (Map.Entry<String, JsonObject> field
                            : doc.asMap().entrySet()) {
                            if (field.getKey().startsWith(FIELD_PREF)) {
                                resDoc.put(
                                    field.getKey().substring(FIELD_PREF.length()),
                                    field.getValue());
                            }
                        }
                        results.add(resDoc);
                    }
                }
                session.response(HttpStatus.SC_OK,
                    new NStringEntity(
                        JsonType.NORMAL.toString(results),
                        ContentType.APPLICATION_JSON));
            } catch (JsonException e) {
                failed(e);
            }
        }
    }
}
