package ru.yandex.msearch.proxy.api.async.so;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpStatus;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.function.CorpUidPredicate;
import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.msearch.proxy.AsyncHttpServer;
import ru.yandex.parser.searchmap.User;
import ru.yandex.search.prefix.LongPrefix;
import ru.yandex.search.proxy.SearchResultConsumerFactory;
import ru.yandex.search.proxy.universal.PlainUniversalSearchProxyRequestContext;
import ru.yandex.search.result.SearchDocument;
import ru.yandex.search.result.SearchResult;

public class ResolveStidHandler
    implements HttpAsyncRequestHandler<HttpRequest>
{
    private final AsyncHttpServer server;

    public ResolveStidHandler(final AsyncHttpServer server) {
        this.server = server;
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        ProxySession session =
            new BasicProxySession(server, exchange, context);
        long uid = session.params().getLong("uid");
        long mid = session.params().getLong("mid");
        String service;
        if (CorpUidPredicate.INSTANCE.test(uid)) {
            service = server.config().pgCorpQueue();
        } else {
            service = server.config().pgQueue();
        }

        AsyncClient searchClient = server.searchClient().adjust(context);
        server.sequentialRequest(
            session,
            new PlainUniversalSearchProxyRequestContext(
                new User(service, new LongPrefix(uid)),
                null,
                true,
                searchClient,
                session.logger()),
            new BasicAsyncRequestProducerGenerator(
                "/search?resolve-stid&json-type=dollar"
                + "&get=stid,received_date&length=1"
                + "&prefix=" + uid
                + "&text=mid_p:" + mid + "+AND+headers:x-yandex-spam%5c:1"),
            null,
            true,
            SearchResultConsumerFactory.OK,
            session.listener().createContextGeneratorFor(searchClient),
            new Callback(
                session,
                JsonTypeExtractor.NORMAL.extract(session.params())));
    }

    private static class Callback
        extends AbstractProxySessionCallback<SearchResult>
    {
        private final JsonType jsonType;

        Callback(final ProxySession session, final JsonType jsonType) {
            super(session);
            this.jsonType = jsonType;
        }

        @Override
        public void completed(final SearchResult result) {
            List<SearchDocument> docs = result.hitsArray();
            if (!docs.isEmpty()) {
                Map<String, String> attrs = docs.get(0).attrs();
                String stid = attrs.get("stid");
                if (stid != null) {
                    StringBuilderWriter sbw = new StringBuilderWriter();
                    try (JsonWriter writer = jsonType.create(sbw)) {
                        writer.startObject();
                        writer.key("stid");
                        writer.value(stid);
                        writer.key("received_date");
                        writer.value(attrs.get("received_date"));
                        writer.endObject();
                    } catch (IOException e) {
                        failed(e);
                        return;
                    }
                    session.response(HttpStatus.SC_OK, sbw.toString());
                    return;
                }
            }
            session.response(HttpStatus.SC_NOT_FOUND);
        }
    }
}

