package ru.yandex.msearch.proxy.api.async.so;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.request.RequestInfo;
import ru.yandex.http.util.server.HttpServer;
import ru.yandex.parser.string.PositiveLongValidator;
import ru.yandex.search.prefix.LongPrefix;
import ru.yandex.util.timesource.TimeSource;

public class UpdateDkimStatsTask {
    private final long start = TimeSource.INSTANCE.currentTimeMillis();
    private final String from;
    private final LongPrefix prefix;
    private final long day;
    private final String key;
    private final RequestInfo requestInfo;
    private long total;
    private long dkimless;
    private Map<String, long[]> dkimDomains;
    private int tasksCount;

    UpdateDkimStatsTask(final ProxySession session) throws HttpException {
        DkimStatsSelector selector = new DkimStatsSelector(session);
        from = selector.from();
        prefix = selector.prefix();
        day = selector.day();
        key = from + '/' + day;
        requestInfo =
            (RequestInfo) session.context().getAttribute(
                HttpServer.REQUEST_INFO);
        total = session.params().get(
            "count",
            1L,
            PositiveLongValidator.INSTANCE);
        Set<String> dkimDomains = selector.dkimDomains();
        int size = dkimDomains.size();
        if (size == 0) {
            dkimless = total;
            this.dkimDomains = new HashMap<>(2);
        } else {
            dkimless = 0;
            this.dkimDomains = new HashMap<>(size << 1);
            for (String dkimDomain: dkimDomains) {
                this.dkimDomains.put(dkimDomain, new long[]{total});
            }
        }
        tasksCount = 1;
    }

    public UpdateDkimStatsTask updateWith(final UpdateDkimStatsTask task) {
        total += task.total;
        Map<String, long[]> dkimDomains = task.dkimDomains;
        if (dkimDomains.isEmpty()) {
            dkimless += task.total;
        } else {
            for (Map.Entry<String, long[]> entry: dkimDomains.entrySet()) {
                long[] counter =
                    this.dkimDomains.computeIfAbsent(
                        entry.getKey(),
                        x -> new long[1]);
                counter[0] += entry.getValue()[0];
            }
        }
        ++tasksCount;
        return this;
    }

    public long start() {
        return start;
    }

    public String from() {
        return from;
    }

    public LongPrefix prefix() {
        return prefix;
    }

    public long day() {
        return day;
    }

    public String key() {
        return key;
    }

    public RequestInfo requestInfo() {
        return requestInfo;
    }

    public long total() {
        return total;
    }

    public long dkimless() {
        return dkimless;
    }

    public Map<String, long[]> dkimDomains() {
        return dkimDomains;
    }

    public int tasksCount() {
        return tasksCount;
    }

    @Override
    public String toString() {
        return key();
    }
}
