package ru.yandex.msearch.proxy.api.async.so;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.StaticEntitySendingCallback;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.EmptyAsyncConsumerFactory;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.msearch.proxy.AsyncHttpServer;
import ru.yandex.msearch.proxy.api.async.BasicSession;
import ru.yandex.msearch.proxy.api.async.Session;
import ru.yandex.parser.uri.CgiParams;

public class UpdateWeights implements HttpAsyncRequestHandler<HttpRequest> {
    private static final String UPDATE_BEGINNING =
        "{\"prefix\":" + GetUserWeights.COMPAINS_UID
         + ",\"AddIfNotExists\":true,\"docs\":[";
    private static final String URL_BEGINNING =
        "so_user_weight_" + GetUserWeights.COMPAINS_UID + '_';

    private final AsyncHttpServer server;

    public UpdateWeights(AsyncHttpServer server) {
        this.server = server;
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(
        final HttpRequest httpRequest,
        final HttpContext httpContext)
    {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public void handle(
        HttpRequest request,
        HttpAsyncExchange exchange,
        HttpContext context)
        throws HttpException, IOException
    {
        Session httpSession = new BasicSession(server, exchange, context);
        CgiParams params = httpSession.params();

        StringBuilder body = new StringBuilder(UPDATE_BEGINNING);
        constructUpdateDoc(body, params);
        body.append("]}");

        AsyncClient client =
            server.producerStoreClient().adjust(httpSession.context());
        client.execute(
            server.config().producerStoreConfig().host(),
            new BasicAsyncRequestProducerGenerator(
                "/update?prefix=" + GetUserWeights.COMPAINS_UID +
                    "&service=" + httpSession.server().config().pgQueue(),
                body.toString(),
                ContentType.APPLICATION_JSON),
            EmptyAsyncConsumerFactory.OK,
            httpSession.listener().createContextGeneratorFor(client),
            new StaticEntitySendingCallback<>(httpSession));
    }

    private static void constructUpdateDoc(
        StringBuilder sb, CgiParams params)
        throws BadRequestException
    {
        sb.append("{\"url\":\"")
            .append(URL_BEGINNING)
            .append(params.getString("type"))
            .append("_").append(params.getString("shingle"))
            .append("_").append(params.getString("so_type"))
            .append('\"');

        insertIfPresent(params, sb, "shingle");
        insertIfPresent(params, sb, "type");
        insertIfPresent(params, sb, "timeset");
        insertIfPresent(params, sb, "weight");
        insertIfPresent(params, sb, "so_type");
        insertIfPresent(params, sb, "user");
        insertIfPresent(params, sb, "should_be_malic");
        insertIfPresent(params, sb, "tags");

        String setWghtCnt = params.getOrNull("setwghtcnt");
        if (setWghtCnt != null) {
            sb.append(",\"uw_setwghtcnt\":");
            if ("inc".equals(setWghtCnt)) {
                sb.append("{\"function\":\"inc\"}");
            } else {
                sb.append(setWghtCnt);
            }
        }
        String duration = insertIfPresent(params, sb, "duration");
        if (duration == null) {
            duration = "{\"function\":\"get\", \"args\":[\"uw_duration\"]}";
        }
        String lastSet = insertIfPresent(params, sb, "lastset");
        if (lastSet == null) {
            lastSet = String.valueOf(System.currentTimeMillis() / 1000);
            sb.append(",\"uw_lastset\":").append(lastSet);
        }
        sb.append(",\"uw_valid_until\":{\"function\":\"sum\",\"args\":[")
            .append(lastSet).append(',')
            .append(duration).append("]}}");
    }

    private static String insertIfPresent(
        CgiParams params, StringBuilder sb, String key) {
        String value = params.getOrNull(key);
        if (value != null) {
            sb.append(",\"uw_")
                .append(key)
                .append("\":\"")
                .append(value)
                .append('\"');
        }
        return value;
    }
}
