package ru.yandex.msearch.proxy.api.async.suggest;

import java.util.List;
import java.util.function.Function;

import ru.yandex.function.BiFunction;

public class BasicRequestTextField implements RequestTextField {
    private final String name;
    private final FieldFunction requestFunction;

    public BasicRequestTextField(final String name) {
        this(name, null);
    }

    public BasicRequestTextField(
        final String name,
        final FieldFunction requestFunction)
    {
        this.name = name;
        this.requestFunction = requestFunction;
    }

    public StringBuilder processForRequest(
        final StringBuilder sb,
        final List<String> words)
    {
        return this.requestFunction.apply(sb, words);
    }

    public String processForRequest(
        final List<String> words)
    {
        return this.requestFunction.apply(words);
    }

    public String name() {
        return name;
    }

    public static class ConstantRequestField extends BasicRequestTextField {
        public ConstantRequestField(String name, String value) {
            super(name, new ConstantFunction(value));
        }
    }

    public abstract static class FieldFunction implements
        BiFunction<StringBuilder, List<String>, StringBuilder>,
        Function<List<String>, String>
    {
        protected final boolean wildcard;

        public FieldFunction(final boolean wildcard) {
            this.wildcard = wildcard;
        }

        public FieldFunction() {
            this(false);
        }

        @Override
        public String apply(final List<String> strings) {
            return apply(new StringBuilder(), strings).toString();
        }
    }



    public static class ConstantFunction extends FieldFunction {
        private final String value;

        public ConstantFunction(String value) {
            this.value = value;
        }

        @Override
        public StringBuilder apply(
            final StringBuilder sb,
            final List<String> strings)
        {
            return sb.append(value);
        }
    }
}
