package ru.yandex.msearch.proxy.api.async.suggest;

import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.apache.http.HttpException;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.msearch.proxy.AsyncHttpServer;
import ru.yandex.msearch.proxy.api.async.ProxyParams;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.prefix.Prefix;
import ru.yandex.search.prefix.PrefixType;

public class BasicSuggestLuceneRequest<T extends Suggests<? extends Suggest>>
    implements SuggestLuceneRequest
{
    private final User user;
    private final String luceneRequest;
    private final long failoverSearchDelay;

    public BasicSuggestLuceneRequest(
        final AsyncHttpServer server,
        final SuggestRequest<T> suggestRequest)
        throws HttpException
    {
        CgiParams params = suggestRequest.cgiParams();
        user = SuggestLuceneRequest.buildUser(params, server);

        QueryConstructor query =
            new QueryConstructor("/search-async-mail-suggest?");

        query.append("update-prefix-activity", "true");
        query.append("get", params.getString("get", null));
        String group = params.getString("group", null);
        if (group != null) {
            query.append("group", group);
        }

        for (String dp: params.getAll("dp")) {
            query.append("dp", dp);
        }

        query.append("prefix", user.prefix().toString());
        query.append("service", user.service());
        query.append(
            "merge_func",
            params.getString("merge_func", "none"));

        String request = params.getString("request", "");
        if (!request.isEmpty()) {
            query.append("text", request);
        }

        StringBuilder sort = new StringBuilder("multi(");
        Set<String> fields = suggestRequest.requestParams().fields();
        List<String> order = suggestRequest.requestParams().order();
        Iterator<String> iterator = fields.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            sort.append(iterator.next());
            sort.append(' ');
            sort.append(order.get(index));
            if (iterator.hasNext()) {
                sort.append(',');
            }
            index++;
        }

        sort.append(')');

        query.append("sort", sort.toString());
        query.append("asc", "true");
        query.append("offset", "0");
        int length = suggestRequest.requestParams().length();
        query.append("length", String.valueOf(length));
        this.luceneRequest = query.toString();

        failoverSearchDelay = server.config().failoverSearchDelay();
    }

    public User user() {
        return user;
    }

    public String luceneRequest() {
        return luceneRequest;
    }

    public long failoverSearchDelay() {
        return failoverSearchDelay;
    }
}
