package ru.yandex.msearch.proxy.api.async.suggest;

import java.io.IOException;
import java.io.OutputStreamWriter;

import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

import java.util.logging.Level;

import org.apache.http.Header;
import org.apache.http.HttpStatus;

import org.apache.http.entity.ContentType;

import org.apache.http.nio.entity.NByteArrayEntity;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.YandexHeaders;

import ru.yandex.http.util.nio.NByteArrayEntityFactory;

import ru.yandex.io.DecodableByteArrayOutputStream;

import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;

import ru.yandex.logger.PrefixedLogger;

import ru.yandex.msearch.proxy.AsyncHttpServer;

import ru.yandex.msearch.proxy.api.async.mail.relevance.search.LoggingSession;

import ru.yandex.msearch.proxy.experiment.MalformedUserSplitException;
import ru.yandex.msearch.proxy.experiment.UserSplit;

import ru.yandex.msearch.proxy.logger.ProxyTskvLogger;

import ru.yandex.tskv.TskvString;

public class BasicSuggestPrinter<T extends Suggests<? extends Suggest>>
    extends AbstractProxySessionCallback<T>
{
    private final JsonType jsonType;
    protected final PrefixedLogger logger;
    protected final ProxyTskvLogger tskvLogger;
    protected final String request;

    public BasicSuggestPrinter(
        final AsyncHttpServer server,
        final ProxySession session,
        final String prefix)
        throws BadRequestException
    {
        this(server, session, session.logger().addPrefix(prefix));
    }

    public BasicSuggestPrinter(
        final AsyncHttpServer server,
        final ProxySession session)
        throws BadRequestException
    {
        this(server, session, session.logger());
    }

    public BasicSuggestPrinter(
        final AsyncHttpServer server,
        final ProxySession session,
        final PrefixedLogger logger)
        throws BadRequestException
    {
        super(session);
        this.logger = logger;
        this.jsonType = JsonTypeExtractor.NORMAL.extract(session.params());
        this.request = session.params().getString("request", null);
        this.tskvLogger = server.tskvLogger();
    }

    protected void writeSuggests(
        final T suggests,
        final JsonWriter writer)
        throws IOException
    {
        writer.startArray();
        for (Suggest s: suggests) {
            writer.value(s);
        }
        writer.endArray();
    }

    protected void writeDetails() {

    }

    @Override
    public void completed(final T suggests) {
        logger.info(
            "Request completed: , Suggests num: " + suggests.size());

        session.connection().setHitsCount(Long.toString(suggests.size()));
        DecodableByteArrayOutputStream out =
            new DecodableByteArrayOutputStream();
        CharsetEncoder encoder = session.acceptedCharset().newEncoder()
            .onMalformedInput(CodingErrorAction.REPLACE)
            .onUnmappableCharacter(CodingErrorAction.REPLACE);

        try (OutputStreamWriter outWriter = new OutputStreamWriter(out, encoder);
             JsonWriter writer = jsonType.create(outWriter))
        {
            writeSuggests(suggests, writer);
        } catch (IOException ioe) {
            failed(ioe);
        }

        logSuggest(suggests);
        writeDetails();

        NByteArrayEntity entity =
            out.processWith(NByteArrayEntityFactory.INSTANCE);
        entity.setContentType(
            ContentType.APPLICATION_JSON.withCharset(
                session.acceptedCharset())
                .toString());
        session.response(HttpStatus.SC_OK, entity);
    }

    protected TskvString logRequest(final T suggests) {
        if (tskvLogger == null) {
            return null;
        }

        String reqId = session.params().getString("reqid", "");
        String connectionId =
            session.params().getString("connection_id", null);

        if (request == null || (reqId == null && connectionId == null)) {
            return null;
        }

        Header enabledBoxed =
            session.request().getFirstHeader(YandexHeaders.X_ENABLED_BOXES);

        TskvString prefix = tskvLogger.record(session.context());

        if (connectionId != null) {
            prefix.append("connection_id", connectionId);
        }

        String side = session.params().getString("side", null);

        if (side != null) {
            prefix.append("side", side);
        }

        prefix.append("module", "suggest-request");
        prefix.append("request", request);
        prefix.append("size", suggests.size());

        if (reqId != null) {
            prefix.append(LoggingSession.REQUEST_ID, reqId);
        }

        long timestamp = System.currentTimeMillis() / 1000;
        prefix.append(LoggingSession.REQUEST, request);
        prefix.append(LoggingSession.UNIXTIME, timestamp);

        UserSplit userSplit = null;
        if (enabledBoxed != null) {
            try {
                userSplit = new UserSplit("none", enabledBoxed.getValue(), "");
                prefix.append("exps", userSplit.testsToString());
            } catch (MalformedUserSplitException mue) {
            }
        }

        return prefix;
    }

    protected void logSuggest(final T suggests) {
        TskvString message = logRequest(suggests);
        if (tskvLogger != null && message != null) {
            tskvLogger.log(Level.INFO, message);
        }
    }
}

