package ru.yandex.msearch.proxy.api.async.suggest;

import org.apache.http.concurrent.FutureCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.msearch.proxy.api.async.Session;
import ru.yandex.parser.uri.CgiParams;

public class BasicSuggestRequest<D extends Suggests<? extends Suggest>>
    implements SuggestRequest<D>
{
    private final SuggestSession session;
    private final FutureCallback<? super D> callback;
    private final SuggestRequestParams requestParams;
    private final CgiParams cgiParams;
    private final PrefixedLogger logger;
    private final String prefix;

    public BasicSuggestRequest(
        final SuggestSession session,
        final CgiParams params,
        final SuggestRequestParams requestParams,
        final FutureCallback<? super D> callback,
        final String prefix)
    {
        this.requestParams = requestParams;
        this.callback = callback;
        this.session = session;

        this.cgiParams = params;
        this.prefix = prefix;

        if (prefix == null) {
            this.logger = session.logger();
        } else {
            this.logger = session.logger().addPrefix(prefix);
        }
    }

    @Override
    public String prefix() {
        return prefix;
    }

    public BasicSuggestRequest(
        final SuggestSession session,
        final SuggestRequestParams requestParams,
        final FutureCallback<? super D> callback,
        final String prefix)
    {
        this(session, session.params(), requestParams, callback, prefix);
    }

    public BasicSuggestRequest(
        final SuggestSession session,
        final SuggestRequestParams requestParams,
        final FutureCallback<? super D> callback)
    {
        this(session, requestParams, callback, null);
    }

    public BasicSuggestRequest(
        final SuggestRequest<?> request,
        final SuggestRequestParams requestParams,
        final CgiParams params,
        final FutureCallback<? super D> callback)
    {
        this.session = request.session();
        this.requestParams = requestParams;
        this.cgiParams = params;
        this.callback = callback;
        this.prefix = request.prefix();
        this.logger = request.logger();
    }

    @Override
    public PrefixedLogger logger() {
        return logger;
    }

    @Override
    public SuggestSession session() {
        return session;
    }

    @Override
    public SuggestRequestParams requestParams() {
        return requestParams;
    }

    @Override
    public FutureCallback<? super D> callback() {
        return callback;
    }

    @Override
    public CgiParams cgiParams() {
        return cgiParams;
    }

    @Override
    public SuggestRequest<D> with(
        final SuggestRequestParams requestParams,
        final CgiParams cgiParams,
        final FutureCallback<? super D> callback)
    {
        return new BasicSuggestRequest<>(
            this,
            requestParams,
            cgiParams,
            callback);
    }

    @Override
    public SuggestRequest<D> with(
        final SuggestRequestParams requestParams,
        final FutureCallback<? super D> callback,
        final String prefix)
    {
        return
            new BasicSuggestRequest<>(
                this.session,
                cgiParams,
                requestParams,
                callback,
                prefix);
    }
}
