package ru.yandex.msearch.proxy.api.async.suggest;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

import ru.yandex.msearch.proxy.api.async.suggest.united.Target;

/**
 * BasicSuggests store object
 *
 */
public class BasicSuggests implements Suggests<Suggest> {
    private final Target target;
    private final Set<Suggest> suggests;
    private final int limit;

    public BasicSuggests(final Target target, final int limit) {
        this.suggests = new LinkedHashSet<>(limit);
        this.target = target;
        this.limit = limit;
    }

    public BasicSuggests(
        final Target target,
        final Set<Suggest> suggests,
        final int limit)
    {
        this.suggests = suggests;
        this.target = target;
        this.limit = limit;
    }

    public BasicSuggests(
        final Target target,
        final Collection<String> suggests,
        final int limit)
    {
        this.target = target;
        this.limit = limit;
        this.suggests = new LinkedHashSet<>();

        if (limit > 0) {
            for (String suggest: suggests) {
                this.add(suggest);
            }
        }
    }

    private BasicSuggests(final Target target) {
        this.target = target;
        this.limit = 0;
        this.suggests = Collections.emptySet();
    }

    public int size() {
        return suggests.size();
    }

    public boolean add(final Suggest suggest) {
        if (!limitReached()) {
            suggests.add(suggest);
            return true;
        }

        return false;
    }

    public boolean contains(final Suggest suggest) {
        return suggests.contains(suggest);
    }

    public boolean add(final String suggest) {
        if (!limitReached()) {
            suggests.add(new BasicSuggest(target, suggest));
            return true;
        }

        return false;
    }

    public boolean limitReached() {
        return this.size() >= limit;
    }

    public BasicSuggests copy(final Suggests<? extends Suggest> other) {
        for (Suggest s: other) {
            if (!this.add(s)) {
                return this;
            }
        }

        return this;
    }

    @Override
    public Iterator<Suggest> iterator() {
        return suggests.iterator();
    }

    public static BasicSuggests empty(final Target target) {
        return new BasicSuggests(target);
    }
}
