package ru.yandex.msearch.proxy.api.async.suggest;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

import ru.yandex.msearch.proxy.api.async.suggest.united.Target;

public class CaseInsensitiveSuggests implements Suggests<Suggest> {
    private final Target target;
    private final Map<String, Suggest> suggests;
    private final int limit;

    public CaseInsensitiveSuggests(final Target target, final int limit) {
        this.suggests = new LinkedHashMap<>(limit);
        this.target = target;
        this.limit = limit;
    }

    public CaseInsensitiveSuggests(
        final Target target,
        final Collection<String> suggests,
        final int limit)
    {
        this.target = target;
        this.limit = limit;
        this.suggests = new LinkedHashMap<>(limit);

        if (limit > 0) {
            for (String suggest: suggests) {
                this.add(suggest);
            }
        }
    }

    public int size() {
        return suggests.size();
    }

    public boolean add(final Suggest suggest) {
        if (!limitReached()) {
            suggests.put(suggest.showText().toLowerCase(Locale.ROOT), suggest);
            return true;
        }

        return false;
    }

    public boolean add(final String suggest) {
        if (!limitReached()) {
            suggests.put(
                suggest.toLowerCase(Locale.ROOT),
                new BasicSuggest(target, suggest));

            return true;
        }

        return false;
    }

    public boolean limitReached() {
        return this.size() >= limit;
    }

    @Override
    public Iterator<Suggest> iterator() {
        return suggests.values().iterator();
    }
}
