package ru.yandex.msearch.proxy.api.async.suggest;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SortedSuggests<T extends Suggest> implements Suggests<T> {
    private final Map<String, T> suggests;

    private final int limit;
    private final Comparator<T> orderComparator;
    private final boolean updatedContactRanking;

    public SortedSuggests(final Comparator<T> orderCmp, final int limit) {
        this(orderCmp, limit, false);
    }

    public SortedSuggests(
        final Comparator<T> orderCmp,
        final int limit,
        final boolean updatedContactRanking)
    {
        this.suggests = new LinkedHashMap<>();
        this.limit = limit;
        this.orderComparator = orderCmp;
        this.updatedContactRanking = updatedContactRanking;
    }

    public void add(final T suggest) {
        String key = suggest.searchText().toLowerCase(Locale.ROOT);
        T current = this.suggests.get(key);
        if (current != null) {
            if (updatedContactRanking) {
                if (orderComparator.compare(current, suggest) < 0) {
                    this.suggests.remove(suggest.searchText());
                    this.suggests.put(key, suggest);
                }
            } else {
                if (orderComparator.compare(current, suggest) > 0) {
                    this.suggests.remove(suggest.searchText());
                    this.suggests.put(key, suggest);
                }
            }
            return;
        }
        if (limitReached()) {
            return;
        }
        this.suggests.put(key, suggest);
    }

    public boolean limitReached() {
        return suggests.size() >= limit;
    }

    @Override
    public Iterator<T> iterator() {
        List<T> result = new ArrayList<>(suggests.values());
        result.sort((o1, o2) -> -orderComparator.compare(o1, o2));
        return result.iterator();
    }

    public int size() {
        return suggests.size();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<T> it = iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString());
            sb.append(",");
        }
        return sb.toString();
    }
}
