package ru.yandex.msearch.proxy.api.async.suggest;

import java.io.IOException;
import java.util.Map;

import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;

import ru.yandex.msearch.proxy.api.async.suggest.united.Target;
import ru.yandex.msearch.proxy.api.async.suggest.united.TargetWeight;

public interface Suggest extends JsonValue {
    Target target();

    String showText();

    String searchText();

    Map<String, String> searchParams();

    Suggest withPrefix(final String prefix);

    void appendToWriter(final JsonWriterBase w) throws IOException;

    double[] factors();

    default double calcScore(final Map<Target, TargetWeight> weights) {
        TargetWeight tw = weights.get(target());
        if (tw == null) {
            return 0;
        }

        return tw.groupWeight() * 10 + tw.weight();
    }

    default void writeValue(final JsonWriterBase writer) throws IOException {
        writer.startObject();
        appendToWriter(writer);
        writer.endObject();
    }
}
