package ru.yandex.msearch.proxy.api.async.suggest;

import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;

import ru.yandex.msearch.proxy.HttpServer.HttpParams;
import ru.yandex.msearch.proxy.HttpServer.RequestContext;
import ru.yandex.msearch.proxy.api.async.mail.relevance.search.LoggingSession;
import ru.yandex.msearch.proxy.api.async.suggest.united.Target;
import ru.yandex.msearch.proxy.document.Document;
import ru.yandex.msearch.proxy.logger.ProxyTskvLogger;
import ru.yandex.tskv.TskvString;

public class SuggestFactors {
    public enum SuggestFactor {
        TARGET,
        REQUEST_WORDS,
        REQUEST_AT,
        REQUEST_SYMBOLS,
        TRANSLIT,
        SIMILARITY,
        FRESHNESS,
        REUSE_COUNT,
        DOCS_COUNT,
        MESSAGE_TYPE,
        CONTACT_FROM,
        CONTACT_TO,
        CONTACT_MAILS_TO,
        CONTACT_MAILS_FROM,
        FID,
        LID,
    }

    public static final int FACTORS_LEN = SuggestFactor.values().length;

    public static double[] create() {
        return new double[FACTORS_LEN];
    }

    public static void set(
        final double[] factors,
        final SuggestFactor name,
        final double value)
    {
        factors[name.ordinal()] = value;
    }

    public static void oldContacts(
        final ProxyTskvLogger factorsLogger,
        final double[] factors,
        final String requestNorm,
        final Document doc)
    {
        try {
            Map<String, String> attrs = doc.getAttrs();
            set(
                factors,
                SuggestFactor.FRESHNESS,
                System.currentTimeMillis()
                    - Long.parseLong(attrs.get("received_date")));
            String dateBoost = attrs.get("date_boost");
            long mergedDocs =
                Long.parseLong(attrs.getOrDefault("merged_docs_count", "0"));
            if (dateBoost.startsWith("1_")) {
                set(factors, SuggestFactor.CONTACT_TO, 1.0);
                set(factors, SuggestFactor.CONTACT_MAILS_TO, mergedDocs);
            } else {
                set(factors, SuggestFactor.CONTACT_FROM, 1.0);
                set(factors, SuggestFactor.CONTACT_MAILS_FROM, mergedDocs);
            }

            set(factors, SuggestFactor.TARGET, Target.CONTACT.ordinal());
            String hash = attrs.getOrDefault("email_hash", "");
            if (!hash.toLowerCase(Locale.ROOT).contains(requestNorm)) {
                set(factors, SuggestFactor.TRANSLIT, 1);
            }

            TskvString record = factorsLogger.record();
            for (SuggestFactor factor: SuggestFactor.values()) {
                record.append(
                    factor.name().toLowerCase(Locale.ROOT),
                    factors[factor.ordinal()]);
            }

            record.append("search_text", hash);

            factorsLogger.log(Level.INFO, record);
        } catch (Exception e) {
        }
    }

    public static void requestFactors(
        final double[] factors,
        final String request)
    {

    }

    public static ProxyTskvLogger prepareLogger(
        final ProxyTskvLogger tskvLogger,
        final String request,
        final RequestContext context,
        final HttpParams params)
    {
        if (tskvLogger == null) {
            return null;
        }

        String reqId = params.get("reqid");

        if (request == null || reqId == null) {
            return null;
        }

        TskvString prefix = tskvLogger.record();

        if (reqId != null) {
            prefix.append(LoggingSession.REQUEST_ID, reqId);
        }

        String connectionId = params.get("connection_id");
        if (connectionId != null) {
            prefix.append("connection_id", connectionId);
        }

        prefix.append("module", "suggest");
        if (request != null) {
            prefix.append("request", request);
        }

        long timestamp = System.currentTimeMillis() / 1000;
        prefix.append(LoggingSession.REQUEST, request);
        prefix.append(LoggingSession.UNIXTIME, timestamp);
        prefix.append("session", context.getSessionId());
        return tskvLogger.prefix(prefix);
    }
}
