package ru.yandex.msearch.proxy.api.async.suggest;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.msearch.proxy.AsyncHttpServer;
import ru.yandex.msearch.proxy.api.async.ProxyParams;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.search.prefix.Prefix;
import ru.yandex.search.prefix.PrefixType;

public interface SuggestLuceneRequest {
    static User buildUser(
        final CgiParams params,
        final AsyncHttpServer server)
        throws BadRequestException
    {
        String mdb = params.getString(ProxyParams.MDB);
        PrefixType prefixType = server.searchMap().prefixType(mdb);
        Prefix suid;
        Prefix uid;
        Prefix prefix;
        if (mdb.equals("pg")) {
            suid = params.get(ProxyParams.SUID, null, prefixType);
            uid = params.get(ProxyParams.UID, prefixType);
            prefix = uid;
        } else {
            suid = params.get(ProxyParams.SUID, prefixType);
            uid = params.get(ProxyParams.UID, null, prefixType);
            prefix = suid;
        }

        return new User(server.resolveService(mdb, prefix), prefix);
    }

    User user();

    String luceneRequest();

    long failoverSearchDelay();
}
