package ru.yandex.msearch.proxy.api.async.suggest;

import java.io.IOException;
import java.io.OutputStreamWriter;

import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

import java.util.logging.Level;

import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NByteArrayEntity;
import org.apache.http.protocol.HttpCoreContext;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.HttpExceptionConverter;

import ru.yandex.http.util.nio.NByteArrayEntityFactory;

import ru.yandex.http.util.server.LoggingServerConnection;

import ru.yandex.io.DecodableByteArrayOutputStream;

import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;

import ru.yandex.logger.PrefixedLogger;
import ru.yandex.logger.SearchProxyAccessLoggerConfigDefaults;

import ru.yandex.msearch.proxy.AsyncHttpServer;
import ru.yandex.msearch.proxy.logger.ProxyTskvLogger;

public class SuggestPrinter
    extends BasicSuggestPrinter<Suggests<? extends Suggest>>
{
    protected final SuggestRequestParams params;
    protected final boolean newFormat;

    public SuggestPrinter(
        final AsyncHttpServer server,
        final ProxySession session,
        final SuggestRequestParams params)
        throws BadRequestException
    {
        super(server, session);

        this.params = params;
        this.newFormat =
            session.params().getBoolean("new-format", false);
    }

    @Override
    protected void writeSuggests(
        final Suggests<? extends Suggest> suggests,
        final JsonWriter writer)
        throws IOException
    {
        if (newFormat) {
            writer.startArray();
            for (Suggest s: suggests) {
                writer.value(s);
            }

            writer.endArray();
        } else  {
            writer.startObject();
            writer.key("documents");
            writer.startArray();
            for (Suggest s: suggests) {
                writer.startObject();
                writer.key("orig_text");
                writer.value(s.showText());
                writer.key("target");
                writer.value(s.target().toString());
                writer.key("show_text");
                writer.value(s.showText());
                writer.key("search_text");
                writer.value(s.searchText());
                writer.endObject();
            }

            writer.endArray();
            writer.endObject();
        }
    }

    @Override
    public void failed(final Exception e) {
        session.logger().log(
            Level.WARNING,
            "Request failed: \n" + session.listener().details(),
            e);

        session.handleException(HttpExceptionConverter.toHttpException(e));
    }

    @Override
    public void cancelled() {
        session.logger().warning("Request cancelled: ");
    }
}
