package ru.yandex.msearch.proxy.api.async.suggest;

import org.apache.http.concurrent.FutureCallback;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.msearch.proxy.api.async.Session;
import ru.yandex.parser.uri.CgiParams;

public interface SuggestRequest<D extends Suggests<? extends Suggest>> {
    SuggestSession session();

    SuggestRequestParams requestParams();

    FutureCallback<? super D> callback();

    CgiParams cgiParams();

    String prefix();

    SuggestRequest<D> with(
        final SuggestRequestParams requestParams,
        final CgiParams cgiParams,
        final FutureCallback<? super D> callback);

    SuggestRequest<D> with(
        final SuggestRequestParams requestParams,
        final FutureCallback<? super D> callback,
        final String prefix);

    default PrefixedLogger logger() {
        return session().logger();
    }

    default SuggestRequest<D> withCallback(
        final FutureCallback<? super D> callback)
    {
        return with(this.requestParams(), this.cgiParams(), callback);
    }

    default SuggestRequest<D> withCgiParams(final CgiParams params) {
        return with(this.requestParams(), params, this.callback());
    }

    default SuggestRequest<D> withRequestParams(
        final SuggestRequestParams params)
    {
        return with(params, this.cgiParams(), this.callback());
    }

    default SuggestRequest<D> with(
        final CgiParams cgiParams,
        final SuggestRequestParams requestParams)
    {
        return with(requestParams, cgiParams, this.callback());
    }

    default SuggestRequest<D> with(
        final CgiParams params,
        final FutureCallback<? super D> callback)
    {
        return with(this.requestParams(), params, callback);
    }
}
