package ru.yandex.msearch.proxy.api.async.suggest;

import java.util.Collections;
import java.util.List;
import java.util.Set;

import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;

import ru.yandex.http.util.nio.client.RequestsListener;

import ru.yandex.http.util.request.RequestInfo;
import ru.yandex.http.util.server.HttpServer;
import ru.yandex.http.util.server.LoggingServerConnection;

import ru.yandex.logger.PrefixedLogger;

import ru.yandex.msearch.proxy.AsyncHttpServer;
import ru.yandex.msearch.proxy.api.async.Session;

import ru.yandex.parser.searchmap.User;

public class SuggestSession
    extends BasicProxySession
    implements Session, ProxySession
{
    protected final AsyncHttpServer server;
    protected final PrefixedLogger logger;
    protected final LoggingServerConnection conn;
    protected final Set<String> experiments;

    public SuggestSession(
        final AsyncHttpServer server,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        super(server, exchange, context);

        this.server = server;
        logger = context().getAttribute(
            AsyncHttpServer.LOGGER,
            PrefixedLogger.class);
        conn = (LoggingServerConnection) context().getConnection();
        conn.setUpstreamStats(listener());
        Object requestInfoObj = context.getAttribute(HttpServer.REQUEST_INFO);
        if (requestInfoObj instanceof RequestInfo) {
            experiments = ((RequestInfo) requestInfoObj).experiments();
        } else {
            experiments = Collections.emptySet();
        }
    }

    @Override
    public AsyncHttpServer server() {
        return server;
    }

    @Override
    public List<HttpHost> searchHosts(final User user) {
        return server().searchMap().searchHosts(user);
    }

    @Override
    public RequestsListener requestsListener() {
        return listener();
    }

    @Override
    public void setSessionInfo(final String name, final String value) {
        conn.setSessionInfo(name, value);
    }

    @Override
    public void handleException(final Exception e) {
        handleException(new HttpException("Http exception wrapper", e));
    }

    public long requestStartTime() {
        return conn.requestStartTime();
    }

    public Set<String> experiments() {
        return experiments;
    }
}
