package ru.yandex.msearch.proxy.api.async.suggest;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import ru.yandex.msearch.proxy.MsearchProxyExperiment;
import ru.yandex.msearch.proxy.api.async.suggest.united.Target;
import ru.yandex.msearch.proxy.api.async.suggest.united.TargetWeight;

public class SuggestWeights {
    public static final Map<Target, TargetWeight> DEFAULT_WEIGHTS;

    static {
        Map<Target, TargetWeight> usual = new HashMap<>();
        usual.put(Target.HISTORY, new TargetWeight(2, 6));
        usual.put(Target.CONTACT, new TargetWeight(2, 5, 6));
        usual.put(Target.SENDER, new TargetWeight(2, 4));
        usual.put(Target.RECEIVER, new TargetWeight(2, 3));
        usual.put(Target.SUBJECT, new TargetWeight(2, 2));
        usual.put(Target.MAIL, new TargetWeight(2, 1));
        usual.put(Target.FOLDER, new TargetWeight(1, 6));
        usual.put(Target.UNREAD, new TargetWeight(1, 5));
        usual.put(Target.IMPORTANT, new TargetWeight(1, 4));
        usual.put(Target.LABEL, new TargetWeight(1, 3));
        usual.put(Target.CATEGORY, new TargetWeight(1, 2));
        usual.put(Target.QL, new TargetWeight(1, 1));

        DEFAULT_WEIGHTS = Collections.unmodifiableMap(usual);
    }

    public static Map<Target, TargetWeight> weights(
        final Set<MsearchProxyExperiment> exps)
    {
        return DEFAULT_WEIGHTS;
    }

    public static TargetWeight weight(
        final Set<MsearchProxyExperiment> exps,
        final Target target)
    {
        return weights(exps).get(target);
    }
}
