package ru.yandex.msearch.proxy.api.async.suggest.contact;

import ru.yandex.msearch.proxy.api.async.suggest.Suggest;
import ru.yandex.msearch.proxy.api.async.suggest.united.Target;

public class BasicContactSuggest extends ContactSuggest implements Suggest {
    public static final Target DEFAULT_TARGET = Target.CONTACT;
    public static final String DISPLAY_NAME = "display_name";
    public static final String EMAIL = "email";
    public static final String UNREAD_CNT = "unread_cnt";

    protected final Target target;
    protected final String displayName;
    protected final String email;
    protected final String emailLow;
    protected final int unreadCnt;
    protected final String searchTxt;
    protected final String showText;
    protected final String hash;
    protected final long timestamp;
    protected final String prefix;
    protected int boost;

    public BasicContactSuggest(
        final String displayName,
        final String email,
        final long timestamp,
        final int unreadCnt)
    {
        this.prefix = "";
        this.target = DEFAULT_TARGET;
        this.timestamp = timestamp;
        this.unreadCnt = unreadCnt;
        this.displayName = ContactSuggestBuilder.formName(displayName, email);
        this.email = email;
        this.emailLow = this.email.toLowerCase();
        this.hash = ContactSuggestBuilder.formHash(displayName, email);
        this.showText = showText(this.displayName, email);
        this.searchTxt = prefix + email;
        this.boost = 0;
    }

    public BasicContactSuggest(
        final Target target,
        final String displayName,
        final String email,
        final String showText,
        final String searchTxt,
        final String prefix,
        final String hash,
        final long timestamp,
        final int unreadCnt,
        final int boost)
    {
        this.prefix = prefix;
        this.target = target;
        this.email = email;
        this.emailLow = email.toLowerCase();
        this.displayName = displayName;
        this.showText = showText;
        this.searchTxt = searchTxt;
        this.boost = boost;
        this.timestamp = timestamp;
        this.unreadCnt = unreadCnt;
        this.hash = hash;
    }

    @Override
    public ContactSuggest withPrefix(final String prefix) {
        return new BasicContactSuggest(
            target,
            displayName,
            email,
            showText,
            prefix + searchTxt,
            this.prefix,
            ContactSuggestBuilder.formHash(displayName, email),
            this.timestamp,
            this.unreadCnt,
            this.boost);
    }

    public int boost() {
        return boost;
    }

    @Override
    public Target target() {
        return target;
    }

    @Override
    public String showText() {
        return showText;
    }

    @Override
    public String searchText() {
        return searchTxt;
    }

    public String displayName() {
        return displayName;
    }

    public String email() {
        return email;
    }

    public String emailLow() {
        return emailLow;
    }

    public int unreadCnt() {
        return unreadCnt;
    }

    public String searchTxt() {
        return searchTxt;
    }

    public String hash() {
        return hash;
    }

    public long timestamp() {
        return timestamp;
    }

    @Override
    public String prefix() {
        return prefix;
    }

    @Override
    public String toString() {
        return "ContactSuggest{" +
            "displayName='" + displayName + '\'' +
            ", email='" + email + '\'' +
            ", emailLow='" + emailLow + '\'' +
            ", unreadCnt=" + unreadCnt +
            ", searchTxt='" + searchTxt + '\'' +
            ", showText='" + showText + '\'' +
            ", hash='" + hash + '\'' +
            ", timestamp=" + timestamp +
            '}';
    }

    public static String showText(
        final String displayName,
        final String email)
    {
        return  "\"" + displayName + "\" " + email;
    }
}
