package ru.yandex.msearch.proxy.api.async.suggest.contact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.codec.DecoderUtil;

import ru.yandex.search.result.SearchDocument;

import ru.yandex.msearch.proxy.api.async.suggest.contact.ContactParser.Email;

public class ContactParserUpdated {
    protected static String removeQuotes(final String str) {
        if (str.indexOf('"') == -1) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        boolean addNext = false;
        for (int i = 0; i < str.length(); i++) {
            char c = str.charAt(i);
            if (addNext) {
                sb.append(c);
                addNext = false;
            }
            if (c == '\\') {
                addNext = true;
                continue;
            } else if (c == '"') {
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static int scanEnd(final String str, final int from) {
        for (int i = from; i < str.length(); i++) {
            if (str.charAt(i) == ' '
                || str.charAt(i) == '\n'
                || str.charAt(i) == '\t'
                || str.charAt(i) == '\r'
                || str.charAt(i) == '\"'
                || str.charAt(i) == '\''
                || str.charAt(i) == '\\'
                || str.charAt(i) == ','
                || str.charAt(i) == '<'
                || str.charAt(i) == '>')
            {
                return i;
            }
        }

        return str.length();
    }

    private static int scanStart(final String str, final int from) {
        for (int i = from; i >= 0; i--) {
            if (str.charAt(i) == ' '
                || str.charAt(i) == '\n'
                || str.charAt(i) == '\t'
                || str.charAt(i) == '\r'
                || str.charAt(i) == '\"'
                || str.charAt(i) == '\''
                || str.charAt(i) == '\\'
                || str.charAt(i) == ','
                || str.charAt(i) == '<'
                || str.charAt(i) == '>')
            {
                return i + 1;
            }
        }

        return 0;
    }

    private static Email createEmail(
        final String str,
        final int emailStart,
        final int emailEnd)
    {
        String name;
        String address;
        if (emailStart > 0) {
            String possibleName = str.substring(0, emailStart);
            name = removeQuotes(possibleName)
                .replace('\"', ' ')
                .replace('\'', ' ')
                .replace('\\', ' ')
                .replace('<', ' ')
                .replace('>', ' ')
                .trim();
        } else {
            name = "";
        }

        address = str.substring(emailStart, emailEnd)
            .replace('\"', ' ')
            .replace('\'', ' ')
            .replace('\\', ' ')
            .replace(',', ' ')
            .replace('<', ' ')
            .replace('>', ' ')
            .replace(')', ' ')
            .replace('(', ' ')
            .trim();

        return new Email(name, address);
    }

    public static List<Email> parse(
        final SearchDocument doc,
        final String header,
        final Collection<String> excludeSet)
    {
        List<Email> emails = new ArrayList<>();
        String str = doc.attrs().get(header);

        if (str == null) {
            return emails;
        }

        str = str.trim();
        if (str.length() == 0 || excludeSet.contains(str)) {
            return emails;
        }

        if (str.startsWith("=?") && str.endsWith("?=")
            || str.startsWith("<=?") && str.endsWith("?=>"))
        {
            str = DecoderUtil.decodeEncodedWords(str, DecodeMonitor.SILENT);
        }

        String[] addresses = str.split("\n");

        for (String address: addresses) {
            int atIndex = address.lastIndexOf('@');
            int emailStart = 0;
            int emailEnd = address.length();
            if (atIndex != -1) {
                emailStart = scanStart(address, atIndex);
                emailEnd = scanEnd(address, atIndex);
            }
            Email email = createEmail(address, emailStart, emailEnd);
            if (!excludeSet.contains(email.address())) {
                emails.add(email);
            }
        }
        return emails;
    }

}
