package ru.yandex.msearch.proxy.api.async.suggest.contact;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;

import ru.yandex.json.writer.JsonWriterBase;

import ru.yandex.msearch.proxy.api.async.suggest.BasicSuggest;
import ru.yandex.msearch.proxy.api.async.suggest.Suggest;
import ru.yandex.msearch.proxy.api.async.suggest.SuggestFactors;
import ru.yandex.msearch.proxy.api.async.suggest.united.Target;
import ru.yandex.msearch.proxy.api.async.suggest.united.TargetWeight;

public abstract class ContactSuggest implements Suggest {
    protected double[] factors;

    public abstract String hash();
    public abstract String email();
    public abstract String displayName();
    public abstract long timestamp();
    public abstract int boost();
    public abstract String emailLow();
    public abstract int unreadCnt();
    public abstract String prefix();

    public ContactSuggest() {
        this.factors = SuggestFactors.create();
    }

    @Override
    public double[] factors() {
        return factors;
    }

    @Override
    public boolean equals(final Object o) {
        if (o instanceof ContactSuggest) {
            ContactSuggest other = (ContactSuggest) o;
            return this.hash().equals(other.hash());
        }

        return false;
    }

    @Override
    public double calcScore(final Map<Target, TargetWeight> weights) {
        float multiword;
        if (prefix().isEmpty()) {
            multiword = 0f;
        } else {
            multiword = -0.5f;
        }

        TargetWeight tw = weights.get(target());
        return (multiword + tw.groupWeight()) * 10 + tw.weight()
            + boost() * 0.01;
    }

    @Override
    public int hashCode() {
        return hash().hashCode();
    }

    public void appendToWriter(final JsonWriterBase writer)
        throws IOException
    {
        writer.key(BasicSuggest.TARGET);
        writer.value(target());
        writer.key(BasicSuggest.SHOW_TEXT);
        writer.value(showText());
        writer.key(BasicSuggest.SEARCH_TEXT);
        writer.value(searchText());
        writer.key(BasicContactSuggest.DISPLAY_NAME);
        writer.value(displayName());
        writer.key(BasicContactSuggest.EMAIL);
        writer.value(email());
        writer.key(BasicContactSuggest.UNREAD_CNT);
        writer.value(unreadCnt());
        writer.key(BasicSuggest.SEARCH_PARAMS);
        writer.value(Collections.emptyMap());
    }

    @Override
    public ContactSuggest withPrefix(final String prefix) {
        return this;
    }

    public boolean filterable() {
        return true;
    }

    @Override
    public Map<String, String> searchParams() {
        return Collections.emptyMap();
    }
}
